/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.embedder.node;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wildwebdeveloper.embedder.node.Activator;
import org.eclipse.wildwebdeveloper.embedder.node.CompressUtils;
import org.osgi.framework.Bundle;

public class NodeJSManager {
    public static final String NODE_ROOT_DIRECTORY = ".node";
    private static final String MACOS_DSCL_SHELL_PREFIX = "UserShell: ";
    private static boolean alreadyWarned;
    private static Properties cachedNodeJsInfoProperties;
    private static final Object EXPAND_LOCK;

    static {
        EXPAND_LOCK = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getNodeJsLocation() {
        File res;
        block12: {
            File nodejs;
            String nodeJsLocation = System.getProperty("org.eclipse.wildwebdeveloper.nodeJSLocation");
            if (nodeJsLocation != null && (nodejs = new File(nodeJsLocation)).exists()) {
                NodeJSManager.validateNodeVersion(nodejs);
                return new File(nodeJsLocation);
            }
            Properties properties = NodeJSManager.getNodeJsInfoProperties();
            if (properties != null) {
                try {
                    File nodePath = NodeJSManager.probeNodeJsExacutable(properties);
                    if (nodePath != null) {
                        return nodePath;
                    }
                    File installationPath = NodeJSManager.probeNodeJsInstallLocationn();
                    if (installationPath == null) break block12;
                    nodePath = new File(installationPath, properties.getProperty("nodePath"));
                    Object object = EXPAND_LOCK;
                    synchronized (object) {
                        if (!(nodePath.exists() && nodePath.canRead() && nodePath.canExecute())) {
                            CompressUtils.unarchive(FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path(properties.getProperty("archiveFile"))), installationPath);
                        }
                    }
                    return nodePath;
                }
                catch (IOException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wildwebdeveloper.embedder.node", e.getMessage(), (Throwable)e));
                }
            }
        }
        if ((res = NodeJSManager.which("node")) == null && NodeJSManager.getDefaultNodePath().exists()) {
            res = NodeJSManager.getDefaultNodePath();
        }
        if (res != null) {
            NodeJSManager.validateNodeVersion(res);
            return res;
        }
        if (!alreadyWarned) {
            NodeJSManager.warnNodeJSMissing();
            alreadyWarned = true;
        }
        return null;
    }

    public static File getNpmLocation() {
        File res;
        String npmFileName = Platform.getOS().equals("win32") ? "npm.cmd" : "npm";
        File nodeJsLocation = NodeJSManager.getNodeJsLocation();
        if (nodeJsLocation != null && (res = new File(nodeJsLocation.getParentFile(), npmFileName)).exists()) {
            return res;
        }
        return NodeJSManager.which(npmFileName);
    }

    public static File getNpmJSLocation() {
        try {
            File npmLocation = NodeJSManager.getNpmLocation().getCanonicalFile();
            if (npmLocation.getAbsolutePath().endsWith(".js")) {
                return npmLocation;
            }
            String path = "node_modules/npm/bin/npm-cli.js";
            if (new File(npmLocation.getParentFile(), "node_modules").exists()) {
                return new File(npmLocation.getParentFile(), path);
            }
            File target = new File(npmLocation.getParentFile().getParentFile(), path);
            if (target.exists()) {
                return target;
            }
            return new File(npmLocation.getParentFile(), "lib/cli.js");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static ProcessBuilder prepareNodeProcessBuilder(String ... commands) {
        return NodeJSManager.prepareNodeProcessBuilder(Arrays.asList(commands));
    }

    public static ProcessBuilder prepareNodeProcessBuilder(List<String> commands) {
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add(NodeJSManager.getNodeJsLocation().getAbsolutePath());
        tmp.addAll(commands);
        return new ProcessBuilder(tmp);
    }

    public static ProcessBuilder prepareNPMProcessBuilder(String ... commands) {
        return NodeJSManager.prepareNPMProcessBuilder(Arrays.asList(commands));
    }

    public static ProcessBuilder prepareNPMProcessBuilder(List<String> commands) {
        ArrayList<String> tmp = new ArrayList<String>();
        tmp.add(NodeJSManager.getNpmJSLocation().getAbsolutePath());
        tmp.addAll(commands);
        return NodeJSManager.prepareNodeProcessBuilder(tmp);
    }

    public static File which(String program) {
        String[] paths;
        File nodePath;
        Properties properties = NodeJSManager.getNodeJsInfoProperties();
        if (properties != null && (nodePath = NodeJSManager.probeNodeJsExacutable(properties)) != null && nodePath.exists() && nodePath.canRead() && nodePath.canExecute()) {
            File exe = new File(nodePath.getParent(), program);
            if (exe.canExecute()) {
                return exe;
            }
            if ("win32".equals(Platform.getOS()) && (exe = new File(nodePath.getParent(), program + ".exe")).canExecute()) {
                return exe;
            }
        }
        String[] stringArray = paths = System.getenv("PATH").split(System.getProperty("path.separator"));
        int n = paths.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            File exe = new File(path, program);
            if (exe.canExecute()) {
                return exe;
            }
            ++n2;
        }
        String res = null;
        String[] command = new String[]{"/bin/bash", "-c", "-l", "which " + program};
        if (Platform.getOS().equals("win32")) {
            command = new String[]{"cmd", "/c", "where " + program};
        } else if (Platform.getOS().equals("macosx")) {
            command = new String[]{NodeJSManager.getDefaultShellMacOS(), "-c", "-li", "which " + program};
        }
        try {
            Throwable throwable = null;
            stringArray = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(command).getInputStream()));){
                res = reader.readLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
        }
        return res != null ? new File(res) : null;
    }

    private static Properties getNodeJsInfoProperties() {
        URL nodeJsInfo;
        if (cachedNodeJsInfoProperties == null && (nodeJsInfo = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("nodejs-info.properties"))) != null) {
            try {
                Throwable throwable = null;
                Object var2_4 = null;
                try (InputStream infoStream = nodeJsInfo.openStream();){
                    Properties properties = new Properties();
                    properties.load(infoStream);
                    cachedNodeJsInfoProperties = properties;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.wildwebdeveloper.embedder.node", e.getMessage(), (Throwable)e));
            }
        }
        return cachedNodeJsInfoProperties;
    }

    private static final File probeNodeJsInstallLocationn() {
        File[] nodeJsLocations;
        File[] fileArray = nodeJsLocations = NodeJSManager.getOrderedInstallationLocations();
        int n = nodeJsLocations.length;
        int n2 = 0;
        while (n2 < n) {
            File installationPath = fileArray[n2];
            if (NodeJSManager.probeDirectoryForInstallation(installationPath)) {
                return installationPath;
            }
            ++n2;
        }
        return null;
    }

    private static final boolean probeDirectoryForInstallation(File directory) {
        if (directory == null) {
            return false;
        }
        if (directory.exists() && directory.isDirectory() && directory.canWrite() && directory.canExecute()) {
            return true;
        }
        return NodeJSManager.probeDirectoryForInstallation(directory.getParentFile());
    }

    private static final File probeNodeJsExacutable(Properties properties) {
        File[] nodeJsLocations;
        File[] fileArray = nodeJsLocations = NodeJSManager.getOrderedInstallationLocations();
        int n = nodeJsLocations.length;
        int n2 = 0;
        while (n2 < n) {
            File installationPath = fileArray[n2];
            File nodePath = NodeJSManager.getNodeJsExecutablen(installationPath, properties);
            if (nodePath != null) {
                return nodePath;
            }
            ++n2;
        }
        return null;
    }

    private static final File[] getOrderedInstallationLocations() {
        return new File[]{NodeJSManager.toFile(Platform.getInstallLocation(), NODE_ROOT_DIRECTORY), NodeJSManager.toFile(Platform.getUserLocation(), NODE_ROOT_DIRECTORY), NodeJSManager.toFile(Platform.getStateLocation((Bundle)Activator.getDefault().getBundle()))};
    }

    private static final File toFile(Location location, String binDirectory) {
        File installLocation;
        File file = installLocation = location != null && location.getURL() != null ? new File(location.getURL().getFile()) : null;
        if (installLocation != null && binDirectory != null) {
            installLocation = new File(installLocation, binDirectory);
        }
        return installLocation;
    }

    private static final File toFile(IPath locationPath) {
        return locationPath != null ? locationPath.toFile() : null;
    }

    private static final File getNodeJsExecutablen(File installationLocation, Properties properties) {
        File nodePath;
        if (installationLocation != null && (nodePath = new File(installationLocation, properties.getProperty("nodePath"))).exists() && nodePath.canRead() && nodePath.canExecute()) {
            return nodePath;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getDefaultShellMacOS() {
        String res = null;
        String[] command = new String[]{"/bin/bash", "-c", "-l", "dscl . -read ~/ UserShell"};
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(command).getInputStream()));){
                res = reader.readLine();
                if (!res.startsWith(MACOS_DSCL_SHELL_PREFIX)) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), "Cannot find default shell. Use '/bin/zsh' instead."));
                    return "/bin/zsh";
                }
                res = res.substring(MACOS_DSCL_SHELL_PREFIX.length());
                return res;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
        }
        return res;
    }

    private static File getDefaultNodePath() {
        return new File(switch (Platform.getOS()) {
            case "macosx" -> "/usr/local/bin/node";
            case "win32" -> "C:\\Program Files\\nodejs\\node.exe";
            default -> "/usr/bin/node";
        });
    }

    private static void validateNodeVersion(File nodeJsLocation) {
        String nodeVersion = null;
        String[] nodeVersionCommand = new String[]{nodeJsLocation.getAbsolutePath(), "-v"};
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec(nodeVersionCommand).getInputStream()));){
                nodeVersion = reader.readLine();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, Activator.getDefault().getBundle().getSymbolicName(), e.getMessage(), (Throwable)e));
        }
        if (nodeVersion == null) {
            NodeJSManager.warnNodeJSVersionCouldNotBeDetermined();
        }
    }

    private static void warnNodeJSMissing() {
        if (!alreadyWarned) {
            Display.getDefault().asyncExec(() -> MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Missing node.js", (String)"Could not find node.js. This will result in editors missing key features.\nPlease make sure node.js is installed and that your PATH environment variable contains the location to the `node` executable."));
        }
        alreadyWarned = true;
    }

    private static void warnNodeJSVersionCouldNotBeDetermined() {
        if (!alreadyWarned) {
            Display.getDefault().asyncExec(() -> MessageDialog.openWarning((Shell)Display.getCurrent().getActiveShell(), (String)"Node.js version could not be determined", (String)"Node.js version could not be determined. Please make sure a recent version of node.js is installed, editors may be missing key features otherwise.\n"));
        }
        alreadyWarned = true;
    }
}

