/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.ui.internal.hover;

import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tm4e.core.model.TMToken;
import org.eclipse.tm4e.ui.internal.model.TMDocumentModel;
import org.eclipse.tm4e.ui.internal.model.TMModelManager;
import org.eclipse.tm4e.ui.internal.preferences.PreferenceHelper;
import org.eclipse.ui.editors.text.EditorsUI;

public class TMTokenTextHover
implements ITextHover,
ITextHoverExtension {
    public IInformationControlCreator getHoverControlCreator() {
        return new AbstractReusableInformationControlCreator(){

            protected IInformationControl doCreateInformationControl(@NonNullByDefault(value={}) Shell parent) {
                return new DefaultInformationControl(parent, EditorsUI.getTooltipAffordanceString());
            }
        };
    }

    public @Nullable String getHoverInfo(@NonNullByDefault(value={}) ITextViewer textViewer, @NonNullByDefault(value={}) IRegion hoverRegion) {
        if (hoverRegion instanceof RegionWithTMToken) {
            RegionWithTMToken regionWithToken = (RegionWithTMToken)hoverRegion;
            String text = regionWithToken.tokenText.replace(' ', '\u00b7').replace('\t', '\u2192');
            return "<b>" + text + "</b> (" + text.length() + " chars)<br><br><b>Token Type:</b> " + regionWithToken.token.type + "<br><b>TextMate Scopes:</b> <li>" + String.join((CharSequence)"<li>", regionWithToken.token.scopes);
        }
        return null;
    }

    public @Nullable IRegion getHoverRegion(@NonNullByDefault(value={}) ITextViewer textViewer, int offset) {
        TMToken nextToken;
        TMToken hoveredToken;
        int lineStartOffset;
        int lineIndex;
        IDocument doc;
        block10: {
            List tokens;
            block9: {
                if (!PreferenceHelper.isTMTokenHoverEnabled()) {
                    return null;
                }
                doc = textViewer.getDocument();
                if (doc == null) {
                    return null;
                }
                TMDocumentModel model = TMModelManager.INSTANCE.getConnectedModel(doc);
                if (model == null) {
                    return null;
                }
                lineIndex = doc.getLineOfOffset(offset);
                tokens = model.getLineTokens(lineIndex);
                if (tokens != null) break block9;
                return null;
            }
            try {
                lineStartOffset = doc.getLineOffset(lineIndex);
                hoveredToken = null;
                nextToken = null;
                for (TMToken token : tokens) {
                    if (token.startIndex <= offset - lineStartOffset) {
                        hoveredToken = token;
                        continue;
                    }
                    nextToken = token;
                    break;
                }
                if (hoveredToken != null) break block10;
                return null;
            }
            catch (BadLocationException e) {
                return null;
            }
        }
        int regionOffset = lineStartOffset + hoveredToken.startIndex;
        int regionLength = nextToken == null ? doc.getLineLength(lineIndex) - hoveredToken.startIndex : nextToken.startIndex - hoveredToken.startIndex;
        return new RegionWithTMToken(regionOffset, regionLength, doc.get(regionOffset, regionLength), hoveredToken);
    }

    private static final class RegionWithTMToken
    extends Region {
        final TMToken token;
        final String tokenText;

        RegionWithTMToken(int offset, int length, String tokenText, TMToken token) {
            super(offset, length);
            this.tokenText = tokenText;
            this.token = token;
        }
    }
}

