import type * as ts from 'typescript/lib/tsserverlibrary';
import Logger from './logger';
import TemplateLanguageService from './template-language-service';
import TemplateSourceHelper from './template-source-helper';
export default class TemplateLanguageServiceProxy {
    private readonly typescript;
    private readonly sourceHelper;
    private readonly templateStringService;
    private readonly _wrappers;
    constructor(typescript: typeof ts, sourceHelper: TemplateSourceHelper, templateStringService: TemplateLanguageService, _logger: Logger);
    decorate(languageService: ts.LanguageService): any;
    private tryAdaptGetSyntaxDiagnostics;
    private tryAdaptGetSemanticDiagnostics;
    private tryAdaptGetQuickInfoAtPosition;
    private tryAdaptGetCompletionsAtPosition;
    private tryAdaptGetCompletionEntryDetails;
    private tryAdaptGetFormattingEditsForRange;
    private tryAdaptGetCodeFixesAtPosition;
    private tryAdaptGetSupportedCodeFixes;
    private tryAdaptGetDefinitionAtPosition;
    private tryAdaptGetDefinitionAndBoundSpan;
    private tryAdaptGetSignatureHelpItemsAtPosition;
    private tryAdaptGetOutliningSpans;
    private tryAdaptGetReferencesAtPosition;
    private tryAdaptGetJsxClosingTagAtPosition;
    private wrap;
    private adaptDiagnosticsCall;
    private translateCompletionInfo;
    private translateCompletionEntry;
    private translateTextChange;
    private translateFileTextChange;
    private translateCodeAction;
    private translateSignatureHelpItems;
    private translateOutliningSpan;
    private translateTextSpan;
    private translateDefinitionInfo;
    private translateReferenceEntry;
}
