import type { LanguageServicePlugin, DocumentSelector, ServiceContext, Disposable, ProviderResult, FormattingOptions } from '@volar/language-service';
import * as json from 'vscode-json-languageservice';
import type { TextDocument } from 'vscode-languageserver-textdocument';
export interface Provide {
    'json/jsonDocument': (document: TextDocument) => json.JSONDocument | undefined;
    'json/languageService': () => json.LanguageService;
}
export interface JSONSchemaSettings {
    fileMatch?: string[];
    url?: string;
    schema?: json.JSONSchema;
    folderUri?: string;
}
export declare function create({ documentSelector, getWorkspaceContextService, isFormattingEnabled, getFormattingOptions, getLanguageSettings, getDocumentLanguageSettings, onDidChangeLanguageSettings, }?: {
    documentSelector?: DocumentSelector;
    getWorkspaceContextService?(context: ServiceContext): json.WorkspaceContextService;
    isFormattingEnabled?(document: TextDocument, context: ServiceContext): ProviderResult<boolean>;
    getFormattingOptions?(document: TextDocument, options: FormattingOptions, context: ServiceContext): ProviderResult<json.FormattingOptions>;
    getLanguageSettings?(context: ServiceContext): ProviderResult<json.LanguageSettings>;
    getDocumentLanguageSettings?(document: TextDocument, context: ServiceContext): ProviderResult<json.DocumentLanguageSettings | undefined>;
    onDidChangeLanguageSettings?(listener: () => void, context: ServiceContext): Disposable;
}): LanguageServicePlugin;
//# sourceMappingURL=index.d.ts.map