"use strict";
const createLanguageServicePlugin_1 = require("@volar/typescript/lib/quickstart/createLanguageServicePlugin");
const vue = require("@vue/language-core");
const common_1 = require("./lib/common");
const server_1 = require("./lib/server");
const windowsPathReg = /\\/g;
const vueCompilerOptions = new WeakMap();
const plugin = (0, createLanguageServicePlugin_1.createLanguageServicePlugin)((ts, info) => {
    const vueOptions = getVueCompilerOptions();
    const languagePlugin = vue.createVueLanguagePlugin(ts, info.languageServiceHost.getCompilationSettings(), vueOptions, id => id);
    vueCompilerOptions.set(info.project, vueOptions);
    return {
        languagePlugins: [languagePlugin],
        setup: language => {
            info.languageService = (0, common_1.proxyLanguageServiceForVue)(ts, language, info.languageService, vueOptions, fileName => fileName);
            if (info.project.projectKind === ts.server.ProjectKind.Configured
                || info.project.projectKind === ts.server.ProjectKind.Inferred) {
                (0, server_1.startNamedPipeServer)(ts, info, language, info.project.projectKind);
            }
            // #3963
            const timer = setInterval(() => {
                if (info.project['program']) {
                    clearInterval(timer);
                    info.project['program'].__vue__ = { language };
                }
            }, 50);
        }
    };
    function getVueCompilerOptions() {
        if (info.project.projectKind === ts.server.ProjectKind.Configured) {
            const tsconfig = info.project.getProjectName();
            return vue.createParsedCommandLine(ts, ts.sys, tsconfig.replace(windowsPathReg, '/')).vueOptions;
        }
        else {
            return vue.createParsedCommandLineByJson(ts, ts.sys, info.languageServiceHost.getCurrentDirectory(), {}).vueOptions;
        }
    }
});
module.exports = plugin;
//# sourceMappingURL=index.js.map