/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.gef.policy.layout.absolute;

import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.core.gef.command.CompoundEditCommand;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.draw2d.geometry.Dimension;
import org.eclipse.wb.draw2d.geometry.Point;
import org.eclipse.wb.gef.core.EditPart;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.gef.core.requests.ChangeBoundsRequest;
import org.eclipse.wb.gef.core.requests.KeyRequest;
import org.eclipse.wb.gef.core.requests.Request;
import org.eclipse.wb.gef.core.tools.ToolUtilities;
import org.eclipse.wb.gef.graphical.policies.LayoutEditPolicy;

public abstract class KeyboardMovingLayoutEditPolicy
extends LayoutEditPolicy {
    private final ChangeBoundsRequest m_changeBoundsRequest = new ChangeBoundsRequest();
    private Timer m_keyDragTimer;
    private boolean m_isKeyboardMoving;

    @Override
    public void performRequest(Request request) {
        if (request instanceof KeyRequest) {
            KeyRequest keyRequest = (KeyRequest)request;
            switch (keyRequest.getKeyCode()) {
                case 0x1000001: 
                case 0x1000002: 
                case 0x1000003: 
                case 0x1000004: {
                    break;
                }
                default: {
                    return;
                }
            }
            List<EditPart> editParts = ToolUtilities.getSelectionWithoutDependants(this.getViewer());
            if (!editParts.isEmpty()) {
                for (EditPart editPart : editParts) {
                    if (this.getHost() != editPart) continue;
                    return;
                }
                if (keyRequest.isPressed()) {
                    this.handleKeyPressed(keyRequest, editParts);
                } else {
                    this.handleKeyReleased();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleKeyPressed(KeyRequest request, List<EditPart> editParts) {
        ChangeBoundsRequest changeBoundsRequest = this.m_changeBoundsRequest;
        synchronized (changeBoundsRequest) {
            if (this.m_keyDragTimer != null) {
                return;
            }
            this.m_isKeyboardMoving = true;
            boolean isResizing = request.isControlKeyPressed();
            this.m_changeBoundsRequest.setEditParts(editParts);
            this.m_changeBoundsRequest.setType(isResizing ? this.getResizeRequestType() : "move");
            if (isResizing) {
                int resizeDirection = this.m_changeBoundsRequest.getResizeDirection();
                Dimension sizeDelta = this.m_changeBoundsRequest.getSizeDelta();
                switch (request.getKeyCode()) {
                    case 0x1000001: {
                        --sizeDelta.height;
                        resizeDirection |= 5;
                        break;
                    }
                    case 0x1000002: {
                        ++sizeDelta.height;
                        resizeDirection |= 5;
                        break;
                    }
                    case 0x1000003: {
                        --sizeDelta.width;
                        resizeDirection |= 0x18;
                        break;
                    }
                    case 0x1000004: {
                        ++sizeDelta.width;
                        resizeDirection |= 0x18;
                    }
                }
                this.m_changeBoundsRequest.setResizeDirection(resizeDirection);
                for (EditPart resizePart : editParts) {
                    resizePart.showSourceFeedback(this.m_changeBoundsRequest);
                }
            } else {
                Point moveDelta = this.m_changeBoundsRequest.getMoveDelta();
                switch (request.getKeyCode()) {
                    case 0x1000001: {
                        --moveDelta.y;
                        break;
                    }
                    case 0x1000002: {
                        ++moveDelta.y;
                        break;
                    }
                    case 0x1000003: {
                        --moveDelta.x;
                        break;
                    }
                    case 0x1000004: {
                        ++moveDelta.x;
                    }
                }
                this.showLayoutTargetFeedback(this.m_changeBoundsRequest);
            }
        }
    }

    private void handleKeyReleased() {
        if (!this.m_isKeyboardMoving) {
            return;
        }
        if (this.m_keyDragTimer == null) {
            this.m_keyDragTimer = new Timer();
            this.m_keyDragTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    Display display = KeyboardMovingLayoutEditPolicy.this.getViewer().getControl().getDisplay();
                    display.syncExec(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            ChangeBoundsRequest changeBoundsRequest = (this).KeyboardMovingLayoutEditPolicy.this.m_changeBoundsRequest;
                            synchronized (changeBoundsRequest) {
                                try {
                                    List<EditPart> editParts = (this).KeyboardMovingLayoutEditPolicy.this.m_changeBoundsRequest.getEditParts();
                                    if (editParts != null && !editParts.isEmpty()) {
                                        CompoundEditCommand command = new CompoundEditCommand((ObjectInfo)KeyboardMovingLayoutEditPolicy.this.getHost().getModel());
                                        if ("move".equals((this).KeyboardMovingLayoutEditPolicy.this.m_changeBoundsRequest.getType())) {
                                            KeyboardMovingLayoutEditPolicy.this.eraseLayoutTargetFeedback((this).KeyboardMovingLayoutEditPolicy.this.m_changeBoundsRequest);
                                            command.add(KeyboardMovingLayoutEditPolicy.this.getCommand((this).KeyboardMovingLayoutEditPolicy.this.m_changeBoundsRequest));
                                        } else {
                                            for (EditPart part : editParts) {
                                                part.eraseSourceFeedback((this).KeyboardMovingLayoutEditPolicy.this.m_changeBoundsRequest);
                                                command.add(part.getCommand((this).KeyboardMovingLayoutEditPolicy.this.m_changeBoundsRequest));
                                            }
                                        }
                                        KeyboardMovingLayoutEditPolicy.this.getViewer().getEditDomain().executeCommand(command);
                                    }
                                }
                                finally {
                                    (this).KeyboardMovingLayoutEditPolicy.this.m_isKeyboardMoving = false;
                                    (this).KeyboardMovingLayoutEditPolicy.this.m_keyDragTimer = null;
                                    (this).KeyboardMovingLayoutEditPolicy.this.m_changeBoundsRequest.setMoveDelta(new Point());
                                    (this).KeyboardMovingLayoutEditPolicy.this.m_changeBoundsRequest.setSizeDelta(new Dimension());
                                    (this).KeyboardMovingLayoutEditPolicy.this.m_changeBoundsRequest.setResizeDirection(0);
                                }
                            }
                        }
                    });
                }
            }, 300L);
        }
    }

    protected final IEditPartViewer getViewer() {
        return this.getHost().getViewer();
    }

    protected final boolean isKeyboardMoving() {
        return this.m_isKeyboardMoving;
    }

    protected abstract String getResizeRequestType();
}

