/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor.presentation;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.presentation.ButtonPropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.editor.presentation.PropertyEditorPresentation;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;
import org.eclipse.wb.internal.core.utils.Pair;

class ButtonPropertyEditorPresentationImpl
extends PropertyEditorPresentation {
    protected final PropertyToControlMap m_propertyToControl = new PropertyToControlMap();
    private final ButtonPropertyEditorPresentation m_presentation;

    public ButtonPropertyEditorPresentationImpl(ButtonPropertyEditorPresentation presentation) {
        this.m_presentation = presentation;
    }

    @Override
    public final void hide(PropertyTable propertyTable, Property property) {
        Control control = this.m_propertyToControl.remove(propertyTable, property);
        if (control != null) {
            control.dispose();
        }
    }

    @Override
    public final int show(PropertyTable propertyTable, Property property, int x, int y, int width, int height) {
        Control control = this.m_propertyToControl.get(propertyTable, property);
        if (control == null) {
            control = this.createControl(propertyTable, property);
        }
        int controlWidth = height;
        int controlX = x + width - controlWidth;
        ButtonPropertyEditorPresentationImpl.setBounds(control, controlX, y, controlWidth, height);
        return controlWidth;
    }

    public void setSelection(PropertyTable propertyTable, Property property, boolean selected) {
        Button button = (Button)this.m_propertyToControl.get(propertyTable, property);
        if (button != null) {
            button.setSelection(selected);
        }
    }

    private Control createControl(PropertyTable propertyTable, Property property) {
        Control control = this.createControlImpl(propertyTable, property);
        this.m_propertyToControl.put(propertyTable, property, control);
        control.addListener(12, e -> {
            Control control = this.m_propertyToControl.remove(propertyTable, property);
        });
        control.addListener(3, event -> {
            propertyTable.deactivateEditor(true);
            propertyTable.setActiveProperty(property);
        });
        control.addListener(4, event -> {
            boolean bl = propertyTable.forceFocus();
        });
        control.addListener(13, event -> {
            try {
                this.getPresentation().onClick(propertyTable, property);
            }
            catch (Throwable e) {
                propertyTable.deactivateEditor(false);
                propertyTable.handleException(e);
            }
        });
        return control;
    }

    protected Control createControlImpl(PropertyTable propertyTable, Property property) {
        Button button = new Button((Composite)propertyTable, this.getPresentation().getStyle());
        button.setImage(this.getPresentation().getImage());
        button.setToolTipText(this.getPresentation().getTooltip());
        return button;
    }

    protected final ButtonPropertyEditorPresentation getPresentation() {
        return this.m_presentation;
    }

    private static void setBounds(Control control, int newX, int newY, int newWidth, int newHeight) {
        if (newY + newHeight < 0) {
            control.setVisible(false);
            return;
        }
        Rectangle parentArea = control.getParent().getClientArea();
        if (newY > parentArea.height) {
            control.setVisible(false);
            return;
        }
        if (!control.getVisible()) {
            control.setVisible(true);
        }
        Integer oldWidthObject = (Integer)control.getData("oldWidth");
        Integer oldHeightObject = (Integer)control.getData("oldHeight");
        control.setData("oldWidth", (Object)newWidth);
        control.setData("oldHeight", (Object)newHeight);
        if (oldWidthObject != null) {
            int oldWidth = oldWidthObject;
            int oldHeight = oldHeightObject;
            if (oldWidth == newWidth && oldHeight == newHeight) {
                control.setLocation(newX, newY);
                return;
            }
        }
        control.setBounds(newX, newY, newWidth, newHeight);
    }

    protected static final class PropertyToControlMap {
        private final Map<Pair<PropertyTable, Property>, Control> m_map = new HashMap<Pair<PropertyTable, Property>, Control>();

        protected PropertyToControlMap() {
        }

        void put(PropertyTable propertyTable, Property property, Control control) {
            this.m_map.put(Pair.create(propertyTable, property), control);
        }

        Control remove(PropertyTable propertyTable, Property property) {
            return this.m_map.remove(Pair.create(propertyTable, property));
        }

        Control get(PropertyTable propertyTable, Property property) {
            return this.m_map.get(Pair.create(propertyTable, property));
        }
    }
}

