/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.nls.ui;

import java.text.MessageFormat;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wb.core.controls.CTableCombo;
import org.eclipse.wb.internal.core.nls.Messages;
import org.eclipse.wb.internal.core.nls.model.LocaleInfo;
import org.eclipse.wb.internal.core.nls.ui.ChooseLocaleDialog;
import org.eclipse.wb.internal.core.nls.ui.FlagImagesRepository;
import org.eclipse.wb.internal.core.nls.ui.LocaleUtils;

public class NewLocaleDialog
extends ChooseLocaleDialog {
    private final LocaleInfo[] m_locales;
    private CTableCombo m_baseCombo;
    private LocaleInfo m_baseLocale;

    public NewLocaleDialog(Shell parentShell, LocaleInfo[] locales) {
        super(parentShell);
        this.m_locales = locales;
        LocaleUtils.sortByTitle(this.m_locales);
    }

    @Override
    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.NewLocaleDialog_title);
        this.setMessage(Messages.NewLocaleDialog_message);
        Composite container = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(container, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout());
        this.createCopyGroup(composite);
        return container;
    }

    @Override
    protected void updateSelectedLocale() {
        super.updateSelectedLocale();
        int i = 0;
        while (i < this.m_locales.length) {
            LocaleInfo locale = this.m_locales[i];
            if (locale.equals(this.m_selectedLocale)) {
                this.setErrorMessage(MessageFormat.format(Messages.NewLocaleDialog_alreadyExists, this.m_selectedLocale.getTitle()));
                this.getButton(0).setEnabled(false);
                return;
            }
            ++i;
        }
        this.setErrorMessage(null);
        this.getButton(0).setEnabled(true);
    }

    private void createCopyGroup(Composite parent) {
        Group copyGroup = new Group(parent, 0);
        copyGroup.setLayoutData((Object)new GridData(768));
        copyGroup.setLayout((Layout)new GridLayout(2, false));
        copyGroup.setText(Messages.NewLocaleDialog_copyGroup);
        Label countryLabel = new Label((Composite)copyGroup, 0);
        countryLabel.setText(Messages.NewLocaleDialog_copyFrom);
        this.m_baseCombo = new CTableCombo((Composite)copyGroup, 2048);
        this.m_baseCombo.setLayoutData((Object)new GridData(768));
        this.m_baseCombo.add("(none)", FlagImagesRepository.getEmptyFlagImage());
        int i = 0;
        while (i < this.m_locales.length) {
            LocaleInfo locale = this.m_locales[i];
            this.m_baseCombo.add(locale.getTitle(), LocaleUtils.getImage(locale));
            ++i;
        }
        this.m_baseCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = NewLocaleDialog.this.m_baseCombo.getSelectionIndex();
                NewLocaleDialog.this.m_baseLocale = index == 0 ? null : NewLocaleDialog.this.m_locales[index - 1];
            }
        });
        this.m_baseCombo.select(1);
        this.m_baseLocale = this.m_locales[0];
    }

    public LocaleInfo getBaseLocale() {
        return this.m_baseLocale;
    }
}

