/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public abstract class ResizableDialog
extends Dialog {
    public static final String KEY_DIALOG = "KEY_DIALOG";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private final AbstractUIPlugin m_plugin;
    protected Rectangle cachedBounds;

    public ResizableDialog(Shell parentShell, AbstractUIPlugin plugin) {
        super(parentShell);
        this.m_plugin = plugin;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
    }

    protected Point getInitialSize() {
        Rectangle oldBounds;
        this.installDialogBoundsTracker();
        Point defaultSize = this.getDefaultSize();
        if ((this.getShellStyle() & 0x10) != 0 && (oldBounds = this.loadBounds()) != null) {
            Rectangle displayBounds = this.getShell().getDisplay().getBounds();
            int width = Math.min(displayBounds.width, Math.max(oldBounds.width, defaultSize.x));
            int height = Math.min(displayBounds.height, Math.max(oldBounds.height, defaultSize.y));
            return new Point(width, height);
        }
        return defaultSize;
    }

    protected Point getDefaultSize() {
        return super.getInitialSize();
    }

    protected Point getInitialLocation(Point initialSize) {
        Shell windowShell = this.m_plugin.getWorkbench().getActiveWorkbenchWindow().getShell();
        Rectangle windowBounds = windowShell.getBounds();
        Rectangle bounds = this.loadBounds();
        if (bounds != null) {
            int x = bounds.x;
            int y = bounds.y;
            int maxX = windowBounds.x + windowBounds.width - initialSize.x;
            int maxY = windowBounds.y + windowBounds.height - initialSize.y;
            if (x > maxX) {
                x = maxX;
            }
            if (y > maxY) {
                y = maxY;
            }
            if (x < windowBounds.x) {
                x = windowBounds.x;
            }
            if (y < windowBounds.y) {
                y = windowBounds.y;
            }
            return new Point(x, y);
        }
        int x = windowBounds.x + (windowBounds.width - initialSize.x) / 2;
        int y = windowBounds.y + (windowBounds.height - initialSize.y) / 2;
        return new Point(x, y);
    }

    private Rectangle loadBounds() {
        IDialogSettings settings = this.getDialogSettings();
        try {
            return new Rectangle(settings.getInt(X), settings.getInt(Y), settings.getInt(WIDTH), settings.getInt(HEIGHT));
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void saveBounds(Rectangle bounds) {
        IDialogSettings settings = this.getDialogSettings();
        settings.put(X, bounds.x);
        settings.put(Y, bounds.y);
        settings.put(WIDTH, bounds.width);
        settings.put(HEIGHT, bounds.height);
    }

    protected IDialogSettings getDialogSettings() {
        String sectionName;
        IDialogSettings settings = this.m_plugin.getDialogSettings();
        if (settings.getSection(sectionName = this.getDialogSettingsSectionName()) == null) {
            return settings.addNewSection(sectionName);
        }
        return settings.getSection(sectionName);
    }

    protected String getDialogSettingsSectionName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void installDialogBoundsTracker() {
        this.getShell().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                ResizableDialog.this.cachedBounds = ResizableDialog.this.getShell().getBounds();
            }

            public void controlResized(ControlEvent e) {
                ResizableDialog.this.cachedBounds = ResizableDialog.this.getShell().getBounds();
            }
        });
    }

    public boolean close() {
        boolean shellMaximized = this.getShell().getMaximized();
        boolean closed = super.close();
        if (closed && !shellMaximized && this.cachedBounds != null) {
            this.saveBounds(this.cachedBounds);
        }
        return closed;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setData(KEY_DIALOG, (Object)this);
    }
}

