/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorPart;
import org.eclipse.wb.core.controls.flyout.FlyoutControlComposite;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.gef.core.ICommandExceptionHandler;
import org.eclipse.wb.gef.core.IEditPartViewer;
import org.eclipse.wb.internal.core.editor.DesignComposite;
import org.eclipse.wb.internal.core.editor.DesignContextMenuProvider;
import org.eclipse.wb.internal.core.editor.JavaDesignToolbarHelper;
import org.eclipse.wb.internal.core.editor.actions.DesignPageActions;
import org.eclipse.wb.internal.core.editor.actions.SelectSupport;
import org.eclipse.wb.internal.core.editor.palette.DesignerPalette;
import org.eclipse.wb.internal.core.model.DesignRootObject;
import org.eclipse.wb.internal.core.utils.Debug;
import org.eclipse.wb.internal.gef.tree.TreeViewer;

public final class JavaDesignComposite
extends DesignComposite {
    private DesignPageActions m_pageActions;
    private JavaDesignToolbarHelper m_toolbarHelper;
    private DesignerPalette m_designerPalette;
    private JavaInfo m_rootObject;
    private DesignComposite.IExtractableControl m_extractablePalette;

    public JavaDesignComposite(Composite parent, int style, IEditorPart editorPart, ICommandExceptionHandler exceptionHandler) {
        super(parent, style, editorPart, exceptionHandler);
    }

    protected void createDesignActions() {
        TreeViewer treeViewer = this.m_componentsComposite.getTreeViewer();
        this.m_pageActions = new DesignPageActions(this.m_editorPart, (IEditPartViewer)treeViewer);
        this.m_viewer.setContextMenu((MenuManager)new DesignContextMenuProvider((IEditPartViewer)this.m_viewer, this.m_pageActions));
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                JavaDesignComposite.this.m_pageActions.dispose();
            }
        });
    }

    protected void createDesignToolbarHelper() {
        this.m_toolbarHelper = new JavaDesignToolbarHelper(this.m_toolBar);
        this.m_toolbarHelper.initialize(this.m_pageActions, (IEditPartViewer)this.m_viewer);
        this.m_toolbarHelper.fill();
    }

    protected void createPalette(FlyoutControlComposite gefComposite) {
        this.m_designerPalette = new DesignerPalette(gefComposite.getFlyoutParent(), 0, true);
    }

    public void onActivate() {
        this.m_pageActions.installActions();
    }

    public void onDeActivate() {
        this.m_pageActions.uninstallActions();
    }

    public IAction getAction(String actionID) {
        return this.m_pageActions.getAction(actionID);
    }

    public void refresh(ObjectInfo rootObject, IProgressMonitor monitor) {
        this.m_rootObject = (JavaInfo)rootObject;
        monitor.subTask("Updating GEF viewer...");
        monitor.worked(1);
        this.m_viewer.setInput((Object)new DesignRootObject(this.m_rootObject));
        this.m_viewer.getControl().setDrawCached(false);
        monitor.subTask("Updating Property Composite...");
        monitor.worked(1);
        this.m_componentsComposite.setInput((IEditPartViewer)this.m_viewer, (ObjectInfo)this.m_rootObject);
        long start = System.currentTimeMillis();
        monitor.subTask("Loading palette...");
        monitor.worked(1);
        String toolkitId = this.m_rootObject.getDescription().getToolkit().getId();
        this.m_designerPalette.setInput((IEditPartViewer)this.m_viewer, this.m_rootObject, toolkitId);
        Debug.println((Object)("palette: " + (System.currentTimeMillis() - start)));
        monitor.subTask("Configuring errors action...");
        monitor.worked(1);
        this.m_pageActions.getErrorsAction().setRoot(this.m_rootObject);
        this.m_pageActions.setRoot(this.m_rootObject);
        this.m_toolbarHelper.setRoot(this.m_rootObject);
        this.m_viewersComposite.setRoot((ObjectInfo)this.m_rootObject);
        new SelectSupport(rootObject, (IEditPartViewer)this.m_viewer, (IEditPartViewer)this.m_componentsComposite.getTreeViewer());
    }

    public void disposeDesign() {
        super.disposeDesign();
        if (!this.m_designerPalette.getControl().isDisposed()) {
            this.m_designerPalette.setInput((IEditPartViewer)this.m_viewer, null, null);
        }
    }

    public DesignComposite.IExtractableControl getExtractablePalette() {
        if (this.m_extractablePalette == null) {
            this.m_extractablePalette = new DesignComposite.ExtractableControl(this.m_designerPalette.getControl(), (Composite)this);
        }
        return this.m_extractablePalette;
    }
}

