/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.editor.style.impl;

import org.apache.commons.lang.ArrayUtils;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.PropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.StringComboPropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.style.AbstractStylePropertyEditor;
import org.eclipse.wb.internal.core.model.property.editor.style.SubStylePropertyImpl;
import org.eclipse.wb.internal.core.model.property.editor.style.actions.RadioStyleAction;

public final class SelectionStylePropertyImpl
extends SubStylePropertyImpl {
    private final long[] m_flags;
    private final int m_defaultIndex;
    private final String[] m_sFlags;

    public SelectionStylePropertyImpl(AbstractStylePropertyEditor editor, String title, long[] flags, String[] sFlags, long defaultFlag) {
        super(editor, title);
        this.m_flags = flags;
        this.m_sFlags = sFlags;
        this.m_defaultIndex = ArrayUtils.indexOf((long[])this.m_flags, (long)defaultFlag);
    }

    @Override
    public void getAsString(StringBuilder builder) {
        builder.append(this.getTitle());
        builder.append(" select: ");
        builder.append(this.m_defaultIndex);
        String[] stringArray = this.m_sFlags;
        int n = this.m_sFlags.length;
        int n2 = 0;
        while (n2 < n) {
            String sFlag = stringArray[n2];
            builder.append(" ");
            builder.append(sFlag);
            ++n2;
        }
    }

    @Override
    public PropertyEditor createEditor() {
        return new StringComboPropertyEditor(this.m_sFlags);
    }

    @Override
    public long getFlag(String sFlag) {
        return this.m_flags[ArrayUtils.indexOf((Object[])this.m_sFlags, (Object)sFlag)];
    }

    @Override
    public String getFlagValue(Property property) throws Exception {
        long style = this.getStyleValue(property);
        int i = 0;
        while (i < this.m_flags.length) {
            if (i != this.m_defaultIndex && (style & this.m_flags[i]) != 0L) {
                return this.m_sFlags[i];
            }
            ++i;
        }
        return null;
    }

    @Override
    public Object getValue(Property property) throws Exception {
        long style = this.getStyleValue(property);
        int i = 0;
        while (i < this.m_flags.length) {
            if ((style & this.m_flags[i]) != 0L) {
                return this.m_sFlags[i];
            }
            ++i;
        }
        return this.m_sFlags[this.m_defaultIndex];
    }

    private long getCurrentFlag(Property property) throws Exception {
        long style = this.getStyleValue(property);
        int i = 0;
        while (i < this.m_flags.length) {
            if ((style & this.m_flags[i]) != 0L) {
                return this.m_flags[i];
            }
            ++i;
        }
        return this.m_flags[this.m_defaultIndex];
    }

    @Override
    public void setValue(Property property, Object value) throws Exception {
        String sFlag;
        int index;
        long style = this.getStyleValue(property) ^ this.getCurrentFlag(property);
        if (value != Property.UNKNOWN_VALUE && (index = ArrayUtils.indexOf((Object[])this.m_sFlags, (Object)(sFlag = (String)value))) != this.m_defaultIndex) {
            style |= this.m_flags[index];
        }
        this.setStyleValue(property, style);
    }

    @Override
    public void contributeActions(Property property, IMenuManager manager) throws Exception {
        manager.add((IContributionItem)new Separator());
        RadioStyleAction defaultAction = null;
        boolean defineChecked = false;
        long style = this.getStyleValue(property);
        int i = 0;
        while (i < this.m_flags.length) {
            RadioStyleAction action = new RadioStyleAction(property, this, this.m_sFlags[i]);
            if ((style & this.m_flags[i]) != 0L) {
                action.setChecked(true);
                defineChecked = true;
            }
            if (this.m_defaultIndex == i) {
                defaultAction = action;
            }
            manager.add((IAction)action);
            ++i;
        }
        if (!defineChecked) {
            defaultAction.setChecked(true);
        }
    }
}

