/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.xml.editor;

import com.google.common.collect.Lists;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.wb.internal.core.DesignerPlugin;
import org.eclipse.wb.internal.core.editor.DesignComposite;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;
import org.eclipse.wb.internal.core.utils.external.ExternalFactoriesHelper;
import org.eclipse.wb.internal.core.utils.ui.GridDataFactory;
import org.eclipse.wb.internal.core.utils.ui.GridLayoutFactory;
import org.eclipse.wb.internal.core.utils.ui.TabFolderDecorator;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;
import org.eclipse.wb.internal.core.views.IDesignCompositeProvider;
import org.eclipse.wb.internal.core.xml.Activator;
import org.eclipse.wb.internal.core.xml.editor.IRefreshStrategy;
import org.eclipse.wb.internal.core.xml.editor.IXmlEditorPage;
import org.eclipse.wb.internal.core.xml.editor.IXmlEditorPageFactory;
import org.eclipse.wb.internal.core.xml.editor.LineControl;
import org.eclipse.wb.internal.core.xml.editor.SourcePage;
import org.eclipse.wb.internal.core.xml.editor.XmlDesignPage;
import org.eclipse.wst.sse.ui.StructuredTextEditor;

public abstract class AbstractXmlEditor
extends MultiPageEditorPart
implements IDesignCompositeProvider {
    private static final String CONTEXT_ID = "org.eclipse.wb.core.xml.editorScope";
    protected StructuredTextEditor m_xmlEditor;
    private SourcePage m_sourcePage;
    private XmlDesignPage m_designPage;
    private final List<IXmlEditorPage> m_additionalPages = Lists.newArrayList();
    private IXmlEditorPage m_activePage;
    private String m_cleanSource;
    private Control m_partControl;
    private Composite m_splitSourceContainer;
    private SashForm m_splitSashForm;
    private final IRefreshStrategy m_splitRefreshStrategy = new IRefreshStrategy(){

        @Override
        public boolean shouldImmediately() {
            return false;
        }

        @Override
        public boolean shouldWithDelay() {
            return this.getPreferenceDelay() > 0;
        }

        @Override
        public boolean shouldOnSave() {
            return this.getPreferenceDelay() <= 0;
        }

        @Override
        public int getDelay() {
            int delay = this.getPreferenceDelay();
            return Math.max(delay, 250);
        }

        private int getPreferenceDelay() {
            IPreferenceStore preferences = DesignerPlugin.getPreferences();
            return preferences.getInt("editor.layout.syncDelay");
        }
    };

    public AbstractXmlEditor() {
        Activator.scheduleCachesLoading();
        DesignerPlugin.configurePreEditor();
    }

    public void dispose() {
        this.m_sourcePage.dispose();
        this.m_designPage.dispose();
        for (IXmlEditorPage page : this.m_additionalPages) {
            page.dispose();
        }
        this.m_activePage = null;
        this.m_sourcePage = null;
        this.m_designPage = null;
        this.m_additionalPages.clear();
        super.dispose();
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        this.initializeTitle(input);
    }

    private void initializeTitle(IEditorInput input) {
        if (input != null) {
            String title = input.getName();
            this.setPartName(title);
        }
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException("Invalid Input: Must be IFileEditorInput");
        }
        super.init(site, editorInput);
    }

    public final IDocument getDocument() {
        return this.m_xmlEditor.getTextViewer().getDocument();
    }

    public final SourcePage getSourcePage() {
        return this.m_sourcePage;
    }

    public final XmlDesignPage getDesignPage() {
        return this.m_designPage;
    }

    public Control getPartControl() {
        return this.m_partControl;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == StructuredTextEditor.class) {
            return this.m_xmlEditor;
        }
        return super.getAdapter(adapter);
    }

    public DesignComposite getDesignComposite() {
        return this.m_designPage.getDesignComposite();
    }

    public void doSave(IProgressMonitor monitor) {
        this.rememberSourceContent();
        this.m_xmlEditor.doSave(monitor);
        if (this.m_splitRefreshStrategy.shouldOnSave()) {
            this.m_designPage.updateGEF();
        }
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void doSaveAs() {
    }

    private boolean isSourceFirst() {
        int layout = DesignerPlugin.getPreferences().getInt("editor.layout");
        return layout == 0 || layout == 5 || layout == 4;
    }

    private boolean isPagesMode() {
        int layout = DesignerPlugin.getPreferences().getInt("editor.layout");
        return layout == 0 || layout == 1;
    }

    private boolean isSplitMode() {
        int layout = DesignerPlugin.getPreferences().getInt("editor.layout");
        return layout == 3 || layout == 5 || layout == 2 || layout == 4;
    }

    private boolean isSplitModeHorizontal() {
        int layout = DesignerPlugin.getPreferences().getInt("editor.layout");
        return layout == 3 || layout == 5;
    }

    protected Composite createPageContainer(Composite parent) {
        this.m_partControl = parent;
        parent = super.createPageContainer(parent);
        if (this.isPagesMode()) {
            return parent;
        }
        int style = this.isSplitModeHorizontal() ? 256 : 512;
        this.m_splitSashForm = new SashForm(parent, style);
        return this.m_splitSashForm;
    }

    protected void createPages() {
        CTabFolder tabFolder = (CTabFolder)this.getContainer();
        TabFolderDecorator.decorate((IWorkbenchPart)this, (CTabFolder)tabFolder);
        if (this.isSourceFirst()) {
            this.createPageXml();
            this.createPageDesign(1);
            this.m_sourcePage.setPageIndex(0);
            this.m_designPage.setPageIndex(1);
        } else {
            this.createPageXml();
            this.createPageDesign(0);
            this.m_designPage.getControl().moveAbove(null);
            this.m_sourcePage.setPageIndex(1);
            this.m_designPage.setPageIndex(0);
        }
        this.createAdditionalPages();
        this.activateEditorContext();
        if (this.isSplitMode()) {
            this.createPageSplit();
        }
    }

    private void createPageSplit() {
        LineControl separator;
        this.trackSourceActivation();
        this.m_splitSourceContainer = new Composite((Composite)this.m_splitSashForm, 0);
        if (this.isSplitModeHorizontal()) {
            GridLayoutFactory.create((Composite)this.m_splitSourceContainer).columns(2).noMargins().noSpacing();
            separator = new LineControl(this.m_splitSourceContainer, 512);
            GridDataFactory.create((Control)separator).grabV().fillV();
        } else {
            GridLayoutFactory.create((Composite)this.m_splitSourceContainer).columns(1).noMargins().noSpacing();
            separator = new LineControl(this.m_splitSourceContainer, 256);
            GridDataFactory.create((Control)separator).grabH().fillH();
        }
        this.m_splitSashForm.setWeights(new int[]{60, 40});
        int sourceIndex = this.m_sourcePage.getPageIndex();
        Control control = this.getControl(sourceIndex);
        control.setParent(this.m_splitSourceContainer);
        control.setVisible(true);
        GridDataFactory.create((Control)control).grab().fill();
        if (this.isSourceFirst()) {
            control.moveAbove(null);
            this.m_splitSourceContainer.moveAbove(null);
        }
        CTabFolder tabFolder = (CTabFolder)this.getContainer();
        CTabItem item = tabFolder.getItem(sourceIndex);
        item.dispose();
        tabFolder.setSelection(0);
        if (tabFolder.getItems().length == 1) {
            tabFolder.setTabHeight(0);
        }
        this.m_designPage.setActive(true);
        this.m_designPage.forceDocumentListener();
        this.m_designPage.setRefreshStrategy(this.m_splitRefreshStrategy);
        this.m_designPage.setActive(false);
        this.pageChange(this.m_sourcePage.getPageIndex());
        this.m_xmlEditor.setFocus();
    }

    private void trackSourceActivation() {
        final Display display = Display.getDefault();
        display.addFilter(3, new Listener(){

            public void handleEvent(Event event) {
                int pageIndex;
                if (AbstractXmlEditor.this.m_sourcePage == null) {
                    display.removeFilter(3, (Listener)this);
                    return;
                }
                Composite sourceControl = (Composite)AbstractXmlEditor.this.m_sourcePage.getControl();
                Composite designControl = AbstractXmlEditor.this.getContainer();
                if (UiUtils.isChildOf((Widget)sourceControl, (Widget)event.widget)) {
                    pageIndex = AbstractXmlEditor.this.m_sourcePage.getPageIndex();
                    AbstractXmlEditor.this.pageChange(pageIndex);
                    AbstractXmlEditor.this.m_designPage.setRefreshStrategy(AbstractXmlEditor.this.m_splitRefreshStrategy);
                }
                if (UiUtils.isChildOf((Widget)designControl, (Widget)event.widget)) {
                    pageIndex = AbstractXmlEditor.this.m_designPage.getPageIndex();
                    AbstractXmlEditor.this.pageChange(pageIndex);
                    AbstractXmlEditor.this.m_designPage.setRefreshStrategy(IRefreshStrategy.IMMEDIATELY);
                }
            }
        });
    }

    public int getActivePage() {
        int pageIndex = super.getActivePage();
        if (this.isSplitMode() && this.m_sourcePage != null) {
            int sourcePageIndex = this.m_sourcePage.getPageIndex();
            if (this.m_activePage == this.m_sourcePage) {
                return sourcePageIndex;
            }
            if (pageIndex >= sourcePageIndex) {
                ++pageIndex;
            }
        }
        return pageIndex;
    }

    protected int getPageCount() {
        int pageCount = super.getPageCount();
        if (this.isSplitMode() && this.m_sourcePage != null) {
            boolean isSourceExtracted;
            boolean bl = isSourceExtracted = !UiUtils.isChildOf((Widget)this.getContainer(), (Widget)this.m_sourcePage.getControl());
            if (isSourceExtracted) {
                ++pageCount;
            }
        }
        return pageCount;
    }

    protected Control getControl(int pageIndex) {
        if (this.isSplitMode() && this.m_sourcePage != null) {
            int sourcePageIndex = this.m_sourcePage.getPageIndex();
            if (pageIndex == sourcePageIndex) {
                return this.m_sourcePage.getControl();
            }
            if (pageIndex > sourcePageIndex) {
                --pageIndex;
            }
        }
        return super.getControl(pageIndex);
    }

    protected IEditorPart getEditor(int pageIndex) {
        if (this.isSplitMode() && this.m_sourcePage != null) {
            int sourcePageIndex = this.m_sourcePage.getPageIndex();
            if (pageIndex == sourcePageIndex) {
                return this.m_xmlEditor;
            }
            if (pageIndex > sourcePageIndex) {
                --pageIndex;
            }
        }
        return super.getEditor(pageIndex);
    }

    private void activateEditorContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext(CONTEXT_ID);
        }
    }

    private void createPageXml() {
        ExecutionUtils.runLog((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                AbstractXmlEditor.this.m_xmlEditor = AbstractXmlEditor.this.createEditorXml();
                int pageIndex = AbstractXmlEditor.this.addPage((IEditorPart)AbstractXmlEditor.this.m_xmlEditor, AbstractXmlEditor.this.getEditorInput());
                Control control = AbstractXmlEditor.this.getControl(pageIndex);
                AbstractXmlEditor.this.m_sourcePage = new SourcePage(AbstractXmlEditor.this.m_xmlEditor, control);
                AbstractXmlEditor.this.m_sourcePage.initialize(AbstractXmlEditor.this);
                AbstractXmlEditor.this.m_sourcePage.setPageIndex(pageIndex);
                AbstractXmlEditor.this.setPageText(pageIndex, AbstractXmlEditor.this.m_sourcePage.getName());
                AbstractXmlEditor.this.setPageImage(pageIndex, AbstractXmlEditor.this.m_sourcePage.getImage());
                AbstractXmlEditor.this.trackDirty();
            }
        });
    }

    protected StructuredTextEditor createEditorXml() {
        return new StructuredTextEditor();
    }

    private void createPageDesign(int pageIndex) {
        this.m_designPage = this.createDesignPage();
        this.addPage(pageIndex, this.m_designPage);
    }

    private void createAdditionalPages() {
        List factories = ExternalFactoriesHelper.getElementsInstances(IXmlEditorPageFactory.class, (String)"org.eclipse.wb.core.xml.XMLEditorPageFactories", (String)"factory");
        for (IXmlEditorPageFactory factory : factories) {
            factory.createPages(this, this.m_additionalPages);
        }
        for (IXmlEditorPage page : this.m_additionalPages) {
            page.initialize(this);
            this.addPage(page);
        }
    }

    private void addPage(IXmlEditorPage page) {
        int index = this.getPageCount();
        this.addPage(index, page);
    }

    private void addPage(int pageIndex, IXmlEditorPage page) {
        page.initialize(this);
        Control control = page.createControl(this.getContainer());
        this.addPage(pageIndex, control);
        page.setPageIndex(pageIndex);
        this.setPageText(pageIndex, page.getName());
        this.setPageImage(pageIndex, page.getImage());
    }

    protected abstract XmlDesignPage createDesignPage();

    private void trackDirty() {
        this.rememberSourceContent();
        this.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                AbstractXmlEditor.this.firePropertyChange(257);
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
    }

    private void rememberSourceContent() {
        this.m_cleanSource = this.getDocument().get();
    }

    public boolean isDirty() {
        return !this.getDocument().get().equals(this.m_cleanSource);
    }

    protected void pageChange(int pageIndex) {
        String callerMethodName;
        boolean isUserPageChangeRequest;
        if (this.isSplitMode() && pageIndex >= this.m_sourcePage.getPageIndex() && (isUserPageChangeRequest = (callerMethodName = Thread.currentThread().getStackTrace()[2].getMethodName()).equals("widgetSelected"))) {
            ++pageIndex;
        }
        IXmlEditorPage activePage = this.m_activePage;
        if (pageIndex == this.m_sourcePage.getPageIndex()) {
            activePage = this.m_sourcePage;
        } else if (pageIndex == this.m_designPage.getPageIndex()) {
            activePage = this.m_designPage;
        } else {
            for (IXmlEditorPage page : this.m_additionalPages) {
                if (pageIndex != page.getPageIndex()) continue;
                activePage = page;
                break;
            }
        }
        if (activePage == this.m_activePage) {
            return;
        }
        if (this.m_activePage != null) {
            this.m_activePage.setActive(false);
            this.m_activePage = null;
        }
        this.m_activePage = activePage;
        CTabItem fakeItem = this.isSplitMode() ? new CTabItem((CTabFolder)this.getContainer(), 0) : null;
        try {
            super.pageChange(pageIndex);
        }
        finally {
            if (fakeItem != null) {
                fakeItem.dispose();
            }
        }
        this.m_activePage = activePage;
        if (this.m_activePage != null) {
            this.m_activePage.setActive(true);
        }
    }

    public void switchSourceDesign() {
        if (this.m_activePage == this.m_sourcePage) {
            this.setActivePage(this.m_designPage);
        } else {
            this.setActivePage(this.m_sourcePage);
        }
    }

    public void showSource() {
        if (this.m_activePage != this.m_sourcePage) {
            this.setActivePage(this.m_sourcePage);
        }
    }

    public void showDesign() {
        if (this.m_activePage != this.m_designPage) {
            this.setActivePage(this.m_designPage);
        }
    }

    private void setActivePage(IXmlEditorPage page) {
        int pageIndex = page.getPageIndex();
        if (this.isPagesMode()) {
            this.setActivePage(pageIndex);
        } else {
            this.pageChange(pageIndex);
        }
        page.getControl().setFocus();
    }

    public void showSourcePosition(final int position) {
        ExecutionUtils.runLogLater((RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                AbstractXmlEditor.this.m_xmlEditor.selectAndReveal(position, 0);
            }
        });
    }
}

