/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swing.databinding.model;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.wb.internal.core.databinding.model.AstObjectInfo;
import org.eclipse.wb.internal.core.databinding.model.CodeGenerationSupport;
import org.eclipse.wb.internal.swing.databinding.model.generic.GenericUtils;
import org.eclipse.wb.internal.swing.databinding.model.generic.IGenericType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimpleClassObjectInfo
extends AstObjectInfo {
    private final String m_abstractClassName;
    protected String m_className;
    private String m_parameters;

    public SimpleClassObjectInfo(String abstractClassName, String className) {
        this.m_abstractClassName = abstractClassName;
        this.m_className = className;
    }

    public String getClassName() {
        return this.m_className;
    }

    public void setClassName(String className) {
        this.m_className = className;
    }

    protected IGenericType[] getTypeArguments() {
        return null;
    }

    public String getParameters() {
        return this.m_parameters;
    }

    public void setParameters(String parameters) {
        this.m_parameters = parameters;
    }

    public String getFullClassName() {
        return StringUtils.isEmpty((String)this.m_parameters) ? this.m_className : String.valueOf(this.m_className) + this.m_parameters;
    }

    public String getSourceCode(List<String> lines, CodeGenerationSupport generationSupport) throws Exception {
        IGenericType[] typeArguments = this.getTypeArguments();
        boolean variable = this.getVariableIdentifier() != null;
        StringBuffer line = new StringBuffer();
        if (variable) {
            if (this.m_abstractClassName == null) {
                line.append(this.m_className);
            } else {
                line.append(this.m_abstractClassName);
            }
            if (generationSupport.useGenerics() && typeArguments != null) {
                line.append(GenericUtils.getTypesSource(typeArguments));
            }
            line.append(" " + this.getVariableIdentifier() + " = ");
        }
        line.append("new " + this.m_className);
        if (generationSupport.useGenerics() && typeArguments != null) {
            line.append(GenericUtils.getTypesSource(typeArguments));
        }
        if (StringUtils.isEmpty((String)this.m_parameters)) {
            line.append("()");
        } else {
            line.append(this.m_parameters);
        }
        if (variable) {
            line.append(";");
            lines.add(line.toString());
            return this.getVariableIdentifier();
        }
        return line.toString();
    }
}

