/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ve.internal.swt.targetvm.unix;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ve.internal.swt.targetvm.unix.DisposeUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageCapture
extends org.eclipse.xwt.tools.ui.imagecapture.swt.ImageCapture {
    static Field Menu_handler;
    static Field Control_handler;
    static final int OBSCURED = 64;
    static final String FIELD_STATE_NAME = "state";
    protected Map<Class<?>, Map<String, Object>> fieldAccessors = new HashMap();
    private static final Object NO_FIELD;

    static {
        try {
            Menu_handler = Menu.class.getField("handle");
            Control_handler = Control.class.getField("handle");
            System.loadLibrary("swt-gtk-print");
        }
        catch (Exception error) {
            error.printStackTrace();
        }
        catch (UnsatisfiedLinkError error) {
            error.printStackTrace();
        }
        NO_FIELD = new Object();
    }

    private native int[] getPixels(int var1, int var2, int var3, int var4, int var5);

    protected Point getTopLeftOfClientarea(Decorations decorations) {
        Point trim = decorations.toControl(decorations.getLocation());
        trim.x = -trim.x;
        trim.y = -trim.y;
        if (decorations.getMenuBar() != null) {
            Menu menu = decorations.getMenuBar();
            try {
                Class<?> osClass = Class.forName("org.eclipse.swt.internal.gtk.OS");
                Method method = osClass.getMethod("GTK_WIDGET_HEIGHT", Integer.TYPE);
                Object ret = method.invoke((Object)menu, Menu_handler.getInt(menu));
                if (ret != null) {
                    int menuBarHeight = (Integer)ret;
                    trim.y -= menuBarHeight;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new Point(trim.x, trim.y);
    }

    protected Image getImageOfControl(Control control, int includeChildren, int maxWidth, int maxHeight) {
        Image image;
        block7: {
            Shell shell;
            int handle;
            image = null;
            if (control instanceof Shell && (handle = this.readIntFieldValue((shell = (Shell)control).getClass(), shell, "shellHandle")) > 0) {
                image = this.getImageOfHandle(handle, shell.getDisplay(), includeChildren, maxWidth, maxHeight);
            }
            try {
                if (image == null) {
                    image = this.getImageOfHandle(Control_handler.getInt(control), control.getDisplay(), includeChildren, maxWidth, maxHeight);
                }
                if (!(control instanceof Decorations)) break block7;
                Decorations decorations = (Decorations)control;
                Rectangle shellBounds = decorations.getBounds();
                Point topLeft = this.getTopLeftOfClientarea(decorations);
                Image realShellImage = new Image((Device)decorations.getDisplay(), shellBounds.width, shellBounds.height);
                Image origImage = image;
                try {
                    this.simulateDecoration(decorations, realShellImage, decorations.getBounds(), decorations.getClientArea(), topLeft);
                    GC gc = new GC((Drawable)realShellImage);
                    gc.drawImage(image, topLeft.x, topLeft.y);
                    DisposeUtil.dispose(gc);
                    image = realShellImage;
                }
                finally {
                    origImage.dispose();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return image;
    }

    protected Image getImageOfHandle(int handle, Display display, int includeChildren, int maxWidth, int maxHeight) {
        int[] tcData = this.getPixels(handle, includeChildren, maxWidth, maxHeight, 0);
        int depth = display.getDepth();
        if (depth == 15) {
            depth = 16;
        }
        if (depth > 24) {
            depth = 24;
        }
        if (tcData != null) {
            int tcWidth = tcData[0];
            int tcHeight = tcData[1];
            int type = tcData[2];
            if (type == 1) {
                int red_mask = tcData[3] == -1 ? 255 : tcData[3];
                int green_mask = tcData[4] == -1 ? 65280 : tcData[4];
                int blue_mask = tcData[5] == -1 ? 0xFF0000 : tcData[5];
                int[] tcPixels = new int[tcData.length - 6];
                System.arraycopy(tcData, 6, tcPixels, 0, tcPixels.length);
                ImageData tcImageData = new ImageData(tcWidth, tcHeight, depth, new PaletteData(red_mask, green_mask, blue_mask));
                tcImageData.setPixels(0, 0, tcPixels.length, tcPixels, 0);
                Image tcImage = new Image((Device)display, tcImageData);
                return tcImage;
            }
            if (type == 2) {
                int numColors = tcData[3];
                RGB[] rgb = new RGB[numColors];
                int colCount = 0;
                while (colCount < numColors) {
                    int r = tcData[4 + colCount * 3 + 0];
                    int g = tcData[4 + colCount * 3 + 1];
                    int b = tcData[4 + colCount * 3 + 2];
                    rgb[colCount] = new RGB(r, g, b);
                    ++colCount;
                }
                PaletteData pd = new PaletteData(rgb);
                ImageData id = new ImageData(tcWidth, tcHeight, depth, pd);
                int offset = 4 + rgb.length * 3;
                int[] pixels = new int[tcData.length - offset];
                System.arraycopy(tcData, offset, pixels, 0, pixels.length);
                id.setPixels(0, 0, pixels.length, pixels, 0);
                Image tcImage = new Image((Device)display, id);
                return tcImage;
            }
            System.err.println("JNI Returned unknown image type");
        }
        return null;
    }

    private void simulateDecoration(Decorations decoration, Image realShellImage, Rectangle bounds, Rectangle clientArea, Point topLeft) {
        GC gc = new GC((Drawable)realShellImage);
        try {
            gc.setBackground(decoration.getDisplay().getSystemColor(22));
            gc.fillRectangle(0, 0, bounds.width, bounds.height);
            gc.setBackground(decoration.getDisplay().getSystemColor(17));
            gc.drawRectangle(topLeft.x - 1, topLeft.y - 1, clientArea.width + 2, clientArea.height + 2);
            gc.setBackground(decoration.getDisplay().getSystemColor(31));
            gc.fillRectangle(0, bounds.height - topLeft.y, topLeft.y, bounds.height);
            gc.fillRectangle(bounds.width - topLeft.y, bounds.height - topLeft.y, bounds.width, bounds.height);
            if ((decoration.getStyle() & 0x4E0) != 0 && topLeft.y > 2) {
                int barHeight = topLeft.y - 2;
                gc.setForeground(decoration.getDisplay().getSystemColor(31));
                gc.setBackground(decoration.getDisplay().getSystemColor(30));
                gc.fillGradientRectangle(0, 0, bounds.width, barHeight, false);
                gc.setForeground(decoration.getDisplay().getSystemColor(30));
                gc.drawText(decoration.getText(), topLeft.y, 2, true);
                if (decoration.getImage() != null && !decoration.getImage().isDisposed()) {
                    Rectangle imageBounds = decoration.getImage().getBounds();
                    if (imageBounds.height <= barHeight) {
                        gc.drawImage(decoration.getImage(), 0, 0);
                    } else {
                        ImageData imageData = decoration.getImage().getImageData();
                        double factor = (double)barHeight / (double)imageBounds.height;
                        int newWidth = (int)((double)imageBounds.width * factor);
                        imageData = imageData.scaledTo(newWidth, barHeight);
                        Image newImage = new Image((Device)decoration.getDisplay(), imageData);
                        gc.drawImage(newImage, 0, 0);
                        newImage.dispose();
                    }
                }
                int rightx = bounds.width - topLeft.y;
                if ((decoration.getStyle() & 0x40) != 0) {
                    gc.setBackground(decoration.getDisplay().getSystemColor(22));
                    gc.fillRectangle(rightx, 0, topLeft.y, topLeft.y);
                    gc.setLineWidth(1);
                    gc.setForeground(decoration.getDisplay().getSystemColor(17));
                    gc.drawRectangle(rightx, 0, topLeft.y, topLeft.y);
                    int lineWidth = topLeft.y / 6;
                    if (lineWidth < 1) {
                        lineWidth = 1;
                    }
                    gc.setLineWidth(lineWidth);
                    gc.setForeground(decoration.getDisplay().getSystemColor(23));
                    gc.drawLine(rightx + (lineWidth *= 2), lineWidth, rightx + topLeft.y - lineWidth, topLeft.y - lineWidth);
                    gc.drawLine(rightx + lineWidth, topLeft.y - lineWidth, rightx + topLeft.y - lineWidth, lineWidth);
                    rightx -= topLeft.y;
                }
                if ((decoration.getStyle() & 0x400) != 0) {
                    gc.setBackground(decoration.getDisplay().getSystemColor(22));
                    gc.fillRectangle(rightx, 0, topLeft.y, topLeft.y);
                    gc.setLineWidth(1);
                    gc.setForeground(decoration.getDisplay().getSystemColor(17));
                    gc.drawRectangle(rightx, 0, topLeft.y, topLeft.y);
                    int lineWidth = topLeft.y / 6;
                    if (lineWidth < 1) {
                        lineWidth = 1;
                    }
                    gc.setLineWidth(lineWidth);
                    gc.setForeground(decoration.getDisplay().getSystemColor(23));
                    gc.drawRectangle(rightx + (lineWidth *= 2), lineWidth, topLeft.y - 2 * lineWidth, topLeft.y - 2 * lineWidth);
                    rightx -= topLeft.y;
                }
                if ((decoration.getStyle() & 0x80) != 0) {
                    gc.setLineWidth(1);
                    gc.setBackground(decoration.getDisplay().getSystemColor(22));
                    gc.fillRectangle(rightx, 0, topLeft.y - 1, topLeft.y - 1);
                    gc.setForeground(decoration.getDisplay().getSystemColor(17));
                    gc.drawRectangle(rightx, 0, topLeft.y - 1, topLeft.y - 1);
                    int lineWidth = topLeft.y / 6;
                    if (lineWidth < 1) {
                        lineWidth = 1;
                    }
                    gc.setLineWidth(lineWidth);
                    gc.setForeground(decoration.getDisplay().getSystemColor(23));
                    gc.drawLine(rightx + (lineWidth *= 2), topLeft.y - lineWidth, rightx + topLeft.y - lineWidth, topLeft.y - lineWidth);
                    rightx -= topLeft.y;
                }
                gc.setLineWidth(1);
                gc.setForeground(decoration.getDisplay().getSystemColor(17));
                gc.drawLine(0, topLeft.y - 1, bounds.width, topLeft.y - 1);
            }
        }
        finally {
            gc.dispose();
        }
    }

    private int readIntFieldValue(Class<?> klass, Object object, String fieldName) {
        try {
            Field field = this.getField(klass, fieldName);
            return field != null ? field.getInt(object) : 0;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return -1;
    }

    private Field getField(Class<?> klass, String fieldName) {
        Object field;
        Map<String, Object> nameToField = this.fieldAccessors.get(klass);
        if (nameToField == null) {
            nameToField = new HashMap<String, Object>();
            this.fieldAccessors.put(klass, nameToField);
        }
        if ((field = nameToField.get(fieldName)) == null) {
            try {
                field = klass.getDeclaredField(fieldName);
                ((Field)field).setAccessible(true);
            }
            catch (SecurityException e) {
                field = NO_FIELD;
                e.printStackTrace();
            }
            catch (NoSuchFieldException e) {
                field = NO_FIELD;
                e.printStackTrace();
            }
            nameToField.put(fieldName, field);
        }
        return (Field)(field != NO_FIELD ? field : null);
    }

    private void writeIntFieldValue(Class<?> klass, Object object, String fieldName, int newInt) {
        try {
            Field field = this.getField(klass, fieldName);
            field.setInt(object, newInt);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    @Override
    protected Image getImage(Control control, int maxWidth, int maxHeight, boolean includeChildren) {
        int ic = includeChildren ? 1 : 0;
        HashMap<Control, Integer> map = new HashMap<Control, Integer>();
        this.changeObscured(control, map, false);
        Image image = null;
        if (!(control instanceof Shell)) {
            Rectangle bounds = control.getBounds();
            image = new Image((Device)control.getDisplay(), bounds.width, bounds.height);
            GC gc = new GC((Drawable)image);
            control.print(gc);
            gc.dispose();
            return image;
        }
        try {
            image = this.getImageOfControl(control, ic, maxWidth, maxHeight);
        }
        finally {
            this.changeObscured(control, map, true);
        }
        return image;
    }

    private void changeObscured(Control control, Map<Control, Integer> map, boolean on) {
        if (on) {
            if (map.containsKey(control)) {
                Integer originalValue = map.get(control);
                this.writeIntFieldValue(Widget.class, control, FIELD_STATE_NAME, originalValue);
            }
        } else {
            int stateValue = this.readIntFieldValue(Widget.class, control, FIELD_STATE_NAME);
            if ((stateValue & 0x40) != 0) {
                map.put(control, new Integer(stateValue));
                this.writeIntFieldValue(Widget.class, control, FIELD_STATE_NAME, stateValue &= 0xFFFFFFBF);
            }
        }
        if (control instanceof CCombo) {
            CCombo ccombo = (CCombo)control;
            Object val = this.readObjectFieldValue(CCombo.class, ccombo, "text");
            if (val instanceof Text) {
                Text text = (Text)val;
                this.changeObscured((Control)text, map, on);
            }
        } else if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] children = composite.getChildren();
            int cc = 0;
            while (children != null && cc < children.length) {
                this.changeObscured(children[cc], map, on);
                ++cc;
            }
        }
    }

    private Object readObjectFieldValue(Class<?> klass, Object object, String fieldName) {
        try {
            Field field = klass.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field.get(object);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }
}

