/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.commands;

import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.tools.ui.designer.commands.DeleteCommand;
import org.eclipse.xwt.tools.ui.designer.commands.FormDataCreateCommand;
import org.eclipse.xwt.tools.ui.designer.core.util.Draw2dTools;
import org.eclipse.xwt.tools.ui.designer.core.util.swt.SWTTools;
import org.eclipse.xwt.tools.ui.designer.loader.XWTProxy;
import org.eclipse.xwt.tools.ui.designer.parts.CompositeEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.ControlEditPart;
import org.eclipse.xwt.tools.ui.designer.policies.layout.form.FormLayoutData;
import org.eclipse.xwt.tools.ui.designer.policies.layout.form.FormLayoutHelper;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class FormDataDeleteCommand
extends Command {
    private EditPart parent;
    private EditPart child;
    private Command command;

    public FormDataDeleteCommand(EditPart parent, EditPart child) {
        this.parent = parent;
        this.child = child;
    }

    public boolean canExecute() {
        if (this.parent == null || this.child == null) {
            return false;
        }
        if (!(this.child instanceof ControlEditPart) || !(this.parent instanceof CompositeEditPart)) {
            return false;
        }
        return this.child.getModel() != null && this.parent.getModel() != null;
    }

    public void execute() {
        CompositeEditPart parentEp = (CompositeEditPart)this.parent;
        ControlEditPart childEp = (ControlEditPart)this.child;
        XamlNode childNode = childEp.getCastModel();
        if (this.child.getParent() == null || this.child.getParent() != this.parent) {
            childEp = (ControlEditPart)((Object)parentEp.getViewer().getEditPartRegistry().get(childNode));
        }
        CompoundCommand commandList = new CompoundCommand();
        commandList.add((Command)new DeleteCommand(childEp.getCastModel()));
        Control control = (Control)childEp.getWidget();
        Control[] dependencies = FormLayoutHelper.getDependencies(control);
        FormLayoutHelper helper = new FormLayoutHelper(parentEp);
        control.dispose();
        if (dependencies.length != 0) {
            Control[] controlArray = dependencies;
            int n = dependencies.length;
            int n2 = 0;
            while (n2 < n) {
                FormLayoutData layoutData;
                Control child = controlArray[n2];
                XamlNode model = XWTProxy.getModel(child);
                if (model != null && (layoutData = helper.computeData(Draw2dTools.toDraw2d((Rectangle)SWTTools.getBounds((Widget)child)), child)) != null) {
                    commandList.add((Command)new FormDataCreateCommand((EditPart)parentEp, model, layoutData.data));
                }
                ++n2;
            }
        }
        this.command = commandList.unwrap();
        if (this.command.canExecute()) {
            this.command.execute();
        }
    }

    public boolean canUndo() {
        return this.command != null && this.command.canUndo();
    }

    public void undo() {
        this.command.undo();
    }
}

