/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.actions;

import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbenchPart;

public abstract class AbstractDropDownAction
extends SelectionAction
implements IMenuCreator {
    protected MenuManager menuManager;

    public AbstractDropDownAction(IWorkbenchPart part) {
        super(part, 4);
        this.setMenuCreator(this);
    }

    protected MenuManager getMenuManager() {
        if (this.menuManager == null) {
            this.menuManager = this.createMenuManager();
        }
        return this.menuManager;
    }

    protected abstract MenuManager createMenuManager();

    public Menu getMenu(Control parent) {
        MenuManager mm = this.getMenuManager();
        if (mm != null) {
            return mm.createContextMenu(parent);
        }
        return null;
    }

    public Menu getMenu(Menu parent) {
        MenuManager mm = this.getMenuManager();
        if (mm != null) {
            Menu menu = new Menu(parent);
            IContributionItem[] items = mm.getItems();
            int i = 0;
            while (i < items.length) {
                IContributionItem item;
                IContributionItem newItem = item = items[i];
                if (item instanceof ActionContributionItem) {
                    newItem = new ActionContributionItem(((ActionContributionItem)item).getAction());
                }
                newItem.fill(menu, -1);
                ++i;
            }
            return menu;
        }
        return null;
    }

    public void dispose() {
        super.dispose();
        if (this.menuManager != null) {
            this.menuManager.dispose();
            this.menuManager = null;
        }
    }
}

