/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.editor.outline.commands;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.xwt.tools.ui.designer.commands.AddNewChildCommand;
import org.eclipse.xwt.tools.ui.designer.commands.DeleteCommand;
import org.eclipse.xwt.tools.ui.designer.editor.outline.commands.MoveCommand;
import org.eclipse.xwt.tools.ui.designer.editor.palette.EntryHelper;
import org.eclipse.xwt.tools.ui.palette.Entry;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class MoveAfterCommand
extends MoveCommand {
    public MoveAfterCommand(IStructuredSelection source, Object target, int operation) {
        super(source, target, operation);
        this.setLabel("Move After");
    }

    public boolean canExecute() {
        return super.canExecute() && this.getTarget().getParent() != null;
    }

    protected void collectCommands(CompoundCommand command) {
        IStructuredSelection sourceNodes = this.getSource();
        XamlNode targetNode = this.getTarget();
        XamlNode parent = targetNode.getParent();
        int index = parent.getChildNodes().indexOf((Object)targetNode);
        XamlNode newNode = null;
        for (Object element : sourceNodes) {
            XamlNode sourceNode = null;
            sourceNode = element instanceof Entry ? EntryHelper.getNode((Entry)element) : (XamlNode)element;
            newNode = sourceNode.eContainer() != null ? (XamlNode)EcoreUtil.copy((EObject)sourceNode) : sourceNode;
            command.add((Command)new AddNewChildCommand(parent, newNode, ++index));
            if (!this.isMove() || sourceNode.eContainer() == null) continue;
            command.add((Command)new DeleteCommand(sourceNode));
        }
    }
}

