/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.core.editor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.gef.EditPart;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xwt.tools.ui.designer.core.parts.RefreshContext;
import org.eclipse.xwt.tools.ui.designer.core.parts.VisualEditPart;
import org.eclipse.xwt.tools.ui.designer.core.util.DisplayUtil;

public class Refresher {
    static int TIMEOUT = 300;
    private Display display;
    private InternalJob job;

    public Refresher(Display uiDisplay) {
        this.display = uiDisplay;
    }

    public void refresh(EditPart editPart, RefreshContext context) {
        if (editPart == null) {
            return;
        }
        try {
            if (editPart instanceof VisualEditPart) {
                ((VisualEditPart)editPart).refresh(context);
            } else {
                editPart.refresh();
            }
            List children = editPart.getChildren();
            for (Object object : children) {
                this.refresh((EditPart)object, context);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void refreshAsynchronous(final EditPart editPart) {
        if (editPart == null) {
            return;
        }
        DisplayUtil.asyncExec(this.getDisplay(), new Runnable(){

            public void run() {
                Refresher.this.refresh(editPart, RefreshContext.ALL());
            }
        });
    }

    public void refreshInJob(EditPart editPart) {
        if (editPart == null) {
            return;
        }
        if (this.job == null) {
            this.job = new InternalJob();
        }
        this.job.refresh(editPart);
    }

    private Display getDisplay() {
        if (this.display == null) {
            this.display = Display.getCurrent();
        }
        return this.display;
    }

    class InternalJob
    extends Job {
        private long timestamp;
        private Set<EditPart> refreshList;

        public InternalJob() {
            super("Refresh Job");
            this.timestamp = -1L;
        }

        private boolean isPosterity(EditPart parent, EditPart child) {
            if (parent == null || child == null) {
                return false;
            }
            EditPart childParent = child.getParent();
            if (parent == childParent) {
                return true;
            }
            return this.isPosterity(parent, childParent);
        }

        private synchronized void refresh(EditPart editPart) {
            if (this.refreshList == null) {
                this.refreshList = new HashSet<EditPart>();
            }
            this.refreshList.add(editPart);
            if (this.timestamp == -1L) {
                this.schedule(TIMEOUT);
            }
            this.timestamp = System.currentTimeMillis();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Set<EditPart> set = this.refreshList;
            synchronized (set) {
                long localTimestamp = System.currentTimeMillis();
                if (localTimestamp - this.timestamp < (long)TIMEOUT) {
                    this.schedule(TIMEOUT);
                    this.timestamp = localTimestamp;
                    return Status.OK_STATUS;
                }
                ArrayList<EditPart> parts = new ArrayList<EditPart>();
                ArrayList<EditPart> doingJobs = new ArrayList<EditPart>(this.refreshList);
                try {
                    for (EditPart ep : doingJobs) {
                        if (parts.isEmpty()) {
                            parts.add(ep);
                            continue;
                        }
                        boolean contains = false;
                        for (EditPart editPart : parts) {
                            if (!this.isPosterity(editPart, ep)) continue;
                            contains = true;
                            break;
                        }
                        if (contains) continue;
                        Iterator iterator = parts.iterator();
                        while (iterator.hasNext()) {
                            EditPart editPart = (EditPart)iterator.next();
                            if (!this.isPosterity(ep, editPart)) continue;
                            iterator.remove();
                        }
                        parts.add(ep);
                    }
                }
                finally {
                    this.refreshList.removeAll(doingJobs);
                }
                if (!parts.isEmpty()) {
                    for (EditPart ep : parts) {
                        try {
                            Refresher.this.refreshAsynchronous(ep);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (!this.refreshList.isEmpty()) {
                    this.schedule(TIMEOUT);
                    this.timestamp = System.currentTimeMillis();
                    return Status.OK_STATUS;
                }
            }
            this.timestamp = -1L;
            return Status.OK_STATUS;
        }
    }
}

