/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.core.problems;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.xwt.tools.ui.designer.core.editor.Designer;
import org.eclipse.xwt.tools.ui.designer.core.problems.IProblemChecker;
import org.eclipse.xwt.tools.ui.designer.core.problems.Problem;
import org.eclipse.xwt.tools.ui.designer.core.problems.ProblemCheckerRegistry;
import org.eclipse.xwt.tools.ui.designer.core.problems.ProblemHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurableProblemHandler
implements ProblemHandler {
    private static final String MARKS_ID = "org.eclipse.xwt.tools.ui.designer.markers";
    private Designer designer;
    private boolean hasProblems;
    private List<IProblemChecker> checkers;

    public ConfigurableProblemHandler(Designer designer) {
        this.designer = designer;
    }

    public void handle(List<Problem> problems) {
        if (!this.isValidate()) {
            return;
        }
        this.clear();
        boolean bl = this.hasProblems = problems != null && !problems.isEmpty();
        if (!this.hasProblems) {
            return;
        }
        try {
            IFile file = this.designer.getFile();
            for (Problem problem : problems) {
                this.makeMaker(file, problem);
            }
            file.refreshLocal(2, null);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private void makeMaker(IFile file, Problem problem) {
        try {
            IMarker marker = file.createMarker(MARKS_ID);
            marker.setAttribute("transient", true);
            marker.setAttribute("message", (Object)problem.getMessage());
            marker.setAttribute("charStart", problem.start);
            marker.setAttribute("charEnd", problem.end);
            int type = problem.getType();
            switch (type) {
                case 3: {
                    marker.setAttribute("severity", 2);
                    break;
                }
                case 2: {
                    marker.setAttribute("severity", 0);
                    break;
                }
                case 1: {
                    marker.setAttribute("severity", 1);
                }
            }
            marker.setAttribute("lineNumber", problem.line);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    @Override
    public void clear() {
        IFile file = this.designer.getFile();
        try {
            file.deleteMarkers(MARKS_ID, true, 2);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    @Override
    public boolean isValidate() {
        return this.designer != null && this.designer.getFile() != null;
    }

    @Override
    public void handle() {
        if (this.checkers == null) {
            this.checkers = ProblemCheckerRegistry.INSTANCE.getCheckers(this.designer.getSite().getPluginId());
        }
        if (this.checkers != null) {
            ArrayList<Problem> problems = new ArrayList<Problem>();
            for (IProblemChecker checker : this.checkers) {
                List<Problem> result;
                if (!checker.isAdapterFor((Object)this.designer) || (result = checker.doCheck()) == null || result.isEmpty()) continue;
                problems.addAll(result);
            }
            this.handle(problems);
        }
    }

    @Override
    public boolean hasProblems() {
        this.handle();
        return this.hasProblems;
    }
}

