/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.commands;

import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.xwt.metadata.IMetaclass;
import org.eclipse.xwt.tools.ui.designer.core.parts.VisualEditPart;
import org.eclipse.xwt.tools.ui.designer.core.visuals.IVisualInfo;
import org.eclipse.xwt.tools.ui.designer.core.visuals.swt.CompositeInfo;
import org.eclipse.xwt.tools.ui.designer.layouts.LayoutType;
import org.eclipse.xwt.tools.ui.designer.layouts.LayoutsHelper;
import org.eclipse.xwt.tools.ui.designer.loader.XWTProxy;
import org.eclipse.xwt.tools.ui.designer.parts.CompositeEditPart;
import org.eclipse.xwt.tools.ui.designer.utils.XWTUtility;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlFactory;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class ChangeLayoutCommand
extends Command {
    private LayoutType layoutType;
    private EditPart editPart;
    private XamlElement element;
    private XamlAttribute layoutAttr;
    private XamlElement newLayout;
    private XamlElement oldLayout;
    private boolean isNewAttr;

    public ChangeLayoutCommand(EditPart editPart, LayoutType layoutType) {
        this.editPart = editPart;
        this.layoutType = layoutType;
    }

    public boolean canExecute() {
        if (this.editPart == null || !(this.editPart instanceof CompositeEditPart)) {
            return false;
        }
        if (this.layoutType == null || this.layoutType == LayoutsHelper.getLayoutType(this.editPart)) {
            return false;
        }
        return this.editPart.getModel() instanceof XamlElement;
    }

    public void execute() {
        EList childNodes;
        this.element = (XamlElement)this.editPart.getModel();
        this.updateLayoutData(this.element, this.layoutType);
        this.layoutAttr = this.element.getAttribute("layout");
        if (this.layoutType == LayoutType.NullLayout) {
            this.element.getAttributes().remove((Object)this.layoutAttr);
            return;
        }
        if (this.layoutAttr == null) {
            this.layoutAttr = XamlFactory.eINSTANCE.createAttribute("layout", "http://www.eclipse.org/xwt/presentation");
            this.isNewAttr = true;
        }
        if ((childNodes = this.layoutAttr.getChildNodes()).size() == 1) {
            this.oldLayout = (XamlElement)childNodes.get(0);
        }
        childNodes.clear();
        if (this.layoutType != LayoutType.NullLayout) {
            this.newLayout = XamlFactory.eINSTANCE.createElement(this.layoutType.value(), "http://www.eclipse.org/xwt/presentation");
            childNodes.add((Object)this.newLayout);
        }
        if (this.isNewAttr && this.layoutType != LayoutType.NullLayout) {
            this.element.getAttributes().add((Object)this.layoutAttr);
        }
    }

    public boolean canUndo() {
        if (this.element == null) {
            return false;
        }
        if (this.isNewAttr) {
            return this.layoutAttr != null;
        }
        return this.layoutAttr != null && this.oldLayout != null;
    }

    public void undo() {
        if (this.isNewAttr) {
            this.element.getAttributes().remove((Object)this.layoutAttr);
        } else if (this.oldLayout != null) {
            this.layoutAttr.getChildNodes().clear();
            this.layoutAttr.getChildNodes().add((Object)this.oldLayout);
        } else if (this.layoutAttr != null && this.element.getAttribute("layout", "http://www.eclipse.org/xwt/presentation") == null) {
            this.element.getAttributes().add((Object)this.layoutAttr);
        }
    }

    private void updateLayoutData(XamlElement element, LayoutType layoutType) {
        block12: {
            block11: {
                if (element == null) {
                    return;
                }
                if (layoutType == LayoutType.NullLayout) break block11;
                EList childNodes = element.getChildNodes();
                for (XamlElement subElement : childNodes) {
                    XamlAttribute attribute = subElement.getAttribute("layoutData");
                    if (attribute == null) continue;
                    subElement.getAttributes().remove((Object)attribute);
                }
                break block12;
            }
            if (this.editPart == null || !(this.editPart instanceof VisualEditPart)) break block12;
            IVisualInfo visualInfo = ((VisualEditPart)this.editPart).getVisualInfo();
            Composite parent = null;
            if (visualInfo != null && visualInfo instanceof CompositeInfo) {
                parent = (Composite)((CompositeInfo)visualInfo).getVisualObject();
            }
            if (parent == null || parent.isDisposed()) {
                return;
            }
            HashMap<XamlNode, Control> model2control = new HashMap<XamlNode, Control>();
            Control[] controlArray = parent.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                model2control.put(XWTProxy.getModel(child), child);
                ++n2;
            }
            EList childNodes = element.getChildNodes();
            for (XamlElement xamlElement : childNodes) {
                XamlAttribute locationAttr;
                XamlAttribute sizeAttr;
                Control control = (Control)model2control.get(xamlElement);
                IMetaclass metaclass = XWTUtility.getMetaclass((XamlNode)xamlElement);
                if (metaclass == null || !Control.class.isAssignableFrom(metaclass.getType()) || control == null) continue;
                Rectangle r = control.getBounds();
                boolean boundsNoExisted = true;
                boolean sizeNoExisted = true;
                boolean locationNoExisted = true;
                XamlAttribute boundsAttr = xamlElement.getAttribute("bounds");
                if (boundsAttr != null) {
                    boundsAttr.setValue(this.toString(r));
                    boundsNoExisted = false;
                }
                if ((sizeAttr = xamlElement.getAttribute("size")) != null) {
                    sizeAttr.setValue(this.toString(new Point(r.width, r.height)));
                    sizeNoExisted = false;
                }
                if ((locationAttr = xamlElement.getAttribute("location")) != null) {
                    locationAttr.setValue(this.toString(new Point(r.x, r.y)));
                    locationNoExisted = false;
                }
                if (boundsNoExisted && sizeNoExisted && locationNoExisted) {
                    boundsAttr = XamlFactory.eINSTANCE.createAttribute("bounds", "http://www.eclipse.org/xwt/presentation");
                    boundsAttr.setValue(this.toString(r));
                    xamlElement.getAttributes().add((Object)boundsAttr);
                    continue;
                }
                if (boundsNoExisted && sizeNoExisted) {
                    sizeAttr = XamlFactory.eINSTANCE.createAttribute("size", "http://www.eclipse.org/xwt/presentation");
                    sizeAttr.setValue(this.toString(new Point(r.width, r.height)));
                    xamlElement.getAttributes().add((Object)sizeAttr);
                    continue;
                }
                if (!boundsNoExisted || !locationNoExisted) continue;
                locationAttr = XamlFactory.eINSTANCE.createAttribute("location", "http://www.eclipse.org/xwt/presentation");
                locationAttr.setValue(this.toString(new Point(r.x, r.y)));
                xamlElement.getAttributes().add((Object)locationAttr);
            }
        }
    }

    private String toString(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Rectangle) {
            Rectangle r = (Rectangle)object;
            return String.valueOf(r.x) + "," + r.y + "," + r.width + "," + r.height;
        }
        if (object instanceof Point) {
            Point p = (Point)object;
            return String.valueOf(p.x) + "," + p.y;
        }
        return object.toString();
    }
}

