/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.databinding;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.xwt.tools.ui.designer.databinding.DataContext;
import org.eclipse.xwt.tools.ui.designer.databinding.IObservable;
import org.eclipse.xwt.tools.ui.designer.databinding.Property;
import org.eclipse.xwt.tools.ui.designer.databinding.PropertyUtil;

public class Observable
implements IObservable {
    private Object source;
    private List<Property> properties;
    private Observable parent;
    private List<IObservable> children;

    Observable(Object source, Observable parent) {
        Assert.isNotNull((Object)source);
        this.source = source;
        this.parent = parent;
        if (parent != null) {
            parent.add(this);
        }
    }

    private void add(Observable observable) {
        if (this.children == null) {
            this.children = new ArrayList<IObservable>();
        }
        if (!this.children.contains(observable)) {
            this.children.add(observable);
        }
    }

    @Override
    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    @Override
    public int getType() {
        if (this.source == null) {
            return 0;
        }
        if (this.source instanceof Widget || this.source instanceof Viewer) {
            return 1;
        }
        return 3;
    }

    @Override
    public Property[] getProperties() {
        if (this.properties == null) {
            this.properties = new ArrayList<Property>();
            Object sourceObj = this.source;
            if (this.source instanceof DataContext) {
                sourceObj = ((DataContext)this.source).getData();
            }
            Map<String, Class<?>> propertiesMap = PropertyUtil.getProperties(sourceObj);
            Set<Map.Entry<String, Class<?>>> entrySet = propertiesMap.entrySet();
            for (Map.Entry<String, Class<?>> entry : entrySet) {
                Property property = new Property(this, entry.getKey(), entry.getValue());
                this.properties.add(property);
            }
        }
        return this.properties.toArray(new Property[this.properties.size()]);
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public String getDisplayName() {
        String simpleName = this.source.getClass().getSimpleName();
        if (this.source instanceof DataContext) {
            simpleName = String.valueOf(simpleName) + "(" + ((DataContext)this.source).getKey() + ")";
        }
        return simpleName;
    }

    @Override
    public IObservable[] getChildren() {
        return this.children == null ? new IObservable[]{} : this.children.toArray(new IObservable[this.children.size()]);
    }

    @Override
    public IObservable getParent() {
        return this.parent;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.source == null ? 0 : this.source.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Observable other = (Observable)obj;
        return !(this.source == null ? other.source != null : !this.source.equals(other.source));
    }

    @Override
    public Property getProperty(String propertyName) {
        Property[] properties;
        if (propertyName == null) {
            return null;
        }
        int index = propertyName.indexOf(".");
        if (index != -1) {
            String parentName = propertyName.substring(0, index);
            propertyName = propertyName.substring(index + 1);
            Property parent = this.getProperty(parentName);
            if (parent != null) {
                return parent.getProperty(propertyName);
            }
        }
        if ((properties = this.getProperties()) == null) {
            return null;
        }
        Property[] propertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            Property p = propertyArray[n2];
            if (propertyName.equalsIgnoreCase(p.getName())) {
                return p;
            }
            ++n2;
        }
        return null;
    }
}

