/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.databinding.ui;

import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.internal.forms.widgets.FormFonts;
import org.eclipse.xwt.tools.ui.designer.databinding.BindingContext;
import org.eclipse.xwt.tools.ui.designer.databinding.BindingInfo;
import org.eclipse.xwt.tools.ui.designer.databinding.IObservable;
import org.eclipse.xwt.tools.ui.designer.databinding.Property;
import org.eclipse.xwt.tools.ui.designer.databinding.ui.CodeGenGroup;
import org.eclipse.xwt.tools.ui.designer.databinding.ui.OptionsGroup;

public class AdvancedBindingDialog
extends TitleAreaDialog {
    private BindingInfo binding;
    private OptionsGroup optionsGroup;
    private CodeGenGroup codeGenGroup;
    private Text elementNameText;

    public AdvancedBindingDialog(Shell parentShell, BindingInfo binding) {
        super(parentShell);
        this.binding = binding;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Advanced Binding Dialog");
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = (Composite)super.createDialogArea(parent);
        Composite control = new Composite(comp, 0);
        control.setLayoutData((Object)new GridData(1808));
        control.setLayout((Layout)new GridLayout(2, false));
        this.createBoldLabel(control, "Target:");
        Label targetLabel = new Label(control, 0);
        targetLabel.setLayoutData((Object)new GridData(768));
        BindingContext bindingContext = this.binding.getBindingContext();
        IObservable target = bindingContext.getTarget();
        String observeName = target.getDisplayName();
        Property property = bindingContext.getTargetProperty();
        if (observeName != null && property != null) {
            targetLabel.setText(String.valueOf(observeName) + "." + property);
        }
        this.createBoldLabel(control, "Model: ");
        Label modelLabel = new Label(control, 0);
        modelLabel.setLayoutData((Object)new GridData(768));
        IObservable model = bindingContext.getModel();
        String observeName2 = model.getDisplayName();
        Property property2 = bindingContext.getModelProperty();
        if (observeName2 != null && property2 != null) {
            modelLabel.setText(String.valueOf(observeName2) + "." + property2);
        }
        if (model.getType() == 1) {
            this.createBoldLabel(control, "ElementName: ");
            this.elementNameText = new Text(control, 2048);
            this.elementNameText.setLayoutData((Object)new GridData(768));
            if (this.binding.getElementName() != null) {
                this.elementNameText.setEditable(false);
                this.elementNameText.setText(this.binding.getElementName());
            }
        }
        final Composite bottom = new Composite(control, 2048);
        bottom.setBackground(control.getDisplay().getSystemColor(1));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        bottom.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        layoutData.horizontalSpan = 2;
        bottom.setLayoutData((Object)layoutData);
        this.optionsGroup = new OptionsGroup();
        final ExpandableComposite optGroup = this.optionsGroup.createGroup(bottom, 0);
        optGroup.setLayoutData((Object)new GridData(768));
        this.optionsGroup.setInput(this.binding);
        this.codeGenGroup = new CodeGenGroup();
        final ExpandableComposite codeGroup = this.codeGenGroup.createGroup(bottom, 0);
        codeGroup.setLayoutData((Object)new GridData(768));
        this.codeGenGroup.setInput(this.binding.getCodeStyles());
        bottom.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                optGroup.setExpanded(false);
                codeGroup.setExpanded(false);
                bottom.layout();
            }
        });
        this.setTitle("Advanced Options");
        this.setMessage("Choose mode and converter for create data binding.");
        return control;
    }

    private void createBoldLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        GridData gd = new GridData();
        gd.horizontalIndent = 5;
        label.setLayoutData((Object)gd);
        label.setFont(FormFonts.getInstance().getBoldFont(label.getDisplay(), label.getFont()));
    }

    protected void okPressed() {
        this.binding.setBindingMode(this.optionsGroup.getBindingMode());
        this.binding.setTriggerMode(this.optionsGroup.getUpdateSourceTrigger());
        Class<?> converter = this.optionsGroup.getConverter();
        if (converter != null) {
            this.binding.setConverter(converter.getName());
        }
        if (this.elementNameText != null) {
            this.binding.setElementName(this.elementNameText.getText());
        }
        this.binding.setCodeStyles(this.codeGenGroup.getCodeStyles());
        super.okPressed();
    }
}

