/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.model;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.xwt.internal.xml.Attribute;
import org.eclipse.xwt.internal.xml.DocumentObject;
import org.eclipse.xwt.internal.xml.Element;
import org.eclipse.xwt.internal.xml.ElementManager;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlDocument;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlFactory;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class XamlDocumentProvider {
    private IFile file;
    private XamlDocument document;
    private boolean needReload = false;
    private static final Map<IFile, XamlDocumentProvider> providers = new HashMap<IFile, XamlDocumentProvider>(1);

    private XamlDocumentProvider(IFile file) {
        Assert.isTrue((file != null && file.exists() ? 1 : 0) != 0);
        this.file = file;
        ResourcesPlugin.getWorkspace().addResourceChangeListener(new IResourceChangeListener(){

            public void resourceChanged(IResourceChangeEvent event) {
                XamlDocumentProvider.this.performResourceChanged(event);
            }
        });
    }

    private void performResourceChanged(IResourceChangeEvent event) {
        if (this.file == null || !this.file.exists()) {
            return;
        }
        IResourceDelta delta = event.getDelta();
        try {
            delta.accept(new IResourceDeltaVisitor(){

                public boolean visit(IResourceDelta delta) throws CoreException {
                    IResource resource = delta.getResource();
                    if (resource != null && XamlDocumentProvider.this.file.getFullPath().equals((Object)resource.getFullPath())) {
                        XamlDocumentProvider.this.needReload = true;
                        return false;
                    }
                    return true;
                }
            });
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public XamlDocument getDocument() {
        boolean reload;
        if (this.document == null) {
            this.document = XamlFactory.eINSTANCE.createXamlDocument();
        }
        boolean bl = reload = this.needReload || this.document.getRootElement() == null;
        if (reload) {
            this.reload();
            this.needReload = false;
        }
        return this.document;
    }

    public boolean reload() {
        URL url;
        block6: {
            if (this.document == null) {
                return false;
            }
            try {
                url = this.file.getLocationURI().toURL();
                if (url != null) break block6;
                return false;
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        ElementManager manager = new ElementManager();
        Element element = manager.load(this.file.getContents(), url);
        XamlElement rootElement = this.document.getRootElement();
        if (rootElement == null) {
            rootElement = XamlFactory.eINSTANCE.createXamlElement();
        }
        this.updateNode((XamlNode)rootElement, (DocumentObject)element);
        if (rootElement.eContainer() == null) {
            this.document.setRootElement(rootElement);
        }
        return true;
    }

    private void updateNode(XamlNode node, DocumentObject obj) {
        if (node == null || obj == null) {
            throw new NullPointerException();
        }
        String namespace = obj.getNamespace();
        node.setId(obj.getId());
        node.setName(obj.getName());
        node.setNamespace(namespace);
        node.setValue(obj.getContent());
        if (obj instanceof Element) {
            String[] attributeNamespaces;
            Element element = (Element)obj;
            ArrayList oldAttributes = new ArrayList(node.getAttributes());
            oldAttributes.removeAll(this.updateAttributes(node, element, null));
            String[] stringArray = attributeNamespaces = element.attributeNamespaces();
            int n = attributeNamespaces.length;
            int n2 = 0;
            while (n2 < n) {
                String ns = stringArray[n2];
                oldAttributes.removeAll(this.updateAttributes(node, element, ns));
                ++n2;
            }
            for (XamlAttribute forRemove : oldAttributes) {
                node.getAttributes().remove((Object)forRemove);
            }
        }
        ArrayList oldChildren = new ArrayList(node.getChildNodes());
        oldChildren.removeAll(this.updateChildNodes(node, obj));
        for (XamlElement forRemove : oldChildren) {
            node.getChildNodes().remove((Object)forRemove);
        }
    }

    private List<XamlElement> updateChildNodes(XamlNode node, DocumentObject obj) {
        ArrayList<XamlElement> updates = new ArrayList<XamlElement>();
        DocumentObject[] children = obj.getChildren();
        int index = 0;
        while (index < children.length) {
            DocumentObject documentObject = children[index];
            XamlElement child = node.getChild(index);
            if (child == null) {
                child = XamlFactory.eINSTANCE.createXamlElement();
            }
            this.updateNode((XamlNode)child, documentObject);
            if (child.eContainer() == null) {
                node.getChildNodes().add((Object)child);
            }
            updates.add(child);
            ++index;
        }
        return updates;
    }

    private List<XamlAttribute> updateAttributes(XamlNode node, Element element, String namespace) {
        String[] attributeNames;
        if (node == null || element == null) {
            throw new NullPointerException();
        }
        ArrayList<XamlAttribute> attrs = new ArrayList<XamlAttribute>();
        String[] stringArray = attributeNames = namespace == null ? element.attributeNames() : element.attributeNames(namespace);
        int n = attributeNames.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute;
            String attrName = stringArray[n2];
            Attribute attribute2 = attribute = namespace == null ? element.getAttribute(attrName) : element.getAttribute(namespace, attrName);
            if (attribute != null) {
                XamlAttribute xa = node.getAttribute(attrName, namespace);
                if (xa == null) {
                    xa = XamlFactory.eINSTANCE.createAttribute(attrName, namespace);
                }
                this.updateNode((XamlNode)xa, (DocumentObject)attribute);
                if (xa.eContainer() == null) {
                    node.getAttributes().add((Object)xa);
                }
                attrs.add(xa);
            }
            ++n2;
        }
        return attrs;
    }

    public static XamlDocument getDocument(IFile file) {
        return XamlDocumentProvider.getProvider(file).getDocument();
    }

    public static XamlDocumentProvider getProvider(IFile file) {
        XamlDocumentProvider p = providers.get(file);
        if (p == null) {
            p = new XamlDocumentProvider(file);
            providers.put(file, p);
        }
        return p;
    }
}

