/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.emf.util;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.dtd.core.internal.emf.DTDAttribute;
import org.eclipse.wst.dtd.core.internal.emf.DTDElement;
import org.eclipse.wst.dtd.core.internal.emf.DTDEntity;
import org.eclipse.wst.dtd.core.internal.emf.DTDFile;
import org.eclipse.wst.dtd.core.internal.emf.DTDNotation;

public class DTDUniqueNameHelper {
    public static String getUniqueElementName(DTDFile dtdFile) {
        List elements = dtdFile.listDTDElement();
        return DTDUniqueNameHelper.getUniqueName(elements, "NewElement");
    }

    public static String getUniqueEntityName(DTDFile dtdFile) {
        List entities = dtdFile.listDTDEntity();
        return DTDUniqueNameHelper.getUniqueName(entities, "NewEntity");
    }

    public static String getUniqueNotationName(DTDFile dtdFile) {
        List notations = dtdFile.listDTDNotation();
        return DTDUniqueNameHelper.getUniqueName(notations, "NewNotation");
    }

    public static String getUniqueAttributeName(DTDElement element) {
        EList attrs = element.getDTDAttribute();
        return DTDUniqueNameHelper.getUniqueName((List)attrs, "NewAttribute");
    }

    public static String getUniqueName(List objs, String token) {
        int counter = 1;
        boolean uniqueName = false;
        while (!uniqueName) {
            String newName = String.valueOf(token) + new Integer(counter++);
            uniqueName = true;
            for (Object obj : objs) {
                String objName = DTDUniqueNameHelper.getName(obj);
                if (!objName.equals(newName)) continue;
                uniqueName = false;
                break;
            }
            if (!uniqueName) continue;
            return newName;
        }
        return "No Name found";
    }

    public static String getName(Object obj) {
        if (obj instanceof DTDElement) {
            return ((DTDElement)obj).getName();
        }
        if (obj instanceof DTDEntity) {
            return ((DTDEntity)obj).getName();
        }
        if (obj instanceof DTDNotation) {
            return ((DTDNotation)obj).getName();
        }
        if (obj instanceof DTDAttribute) {
            return ((DTDAttribute)obj).getName();
        }
        return "";
    }

    protected static String getUniqueElementNameGen(DTDFile dtdFile) {
        List elements = dtdFile.listDTDElement();
        return DTDUniqueNameHelper.getUniqueName(elements, "NewElement");
    }

    protected static String getUniqueEntityNameGen(DTDFile dtdFile) {
        List entities = dtdFile.listDTDEntity();
        return DTDUniqueNameHelper.getUniqueName(entities, "NewEntity");
    }

    protected static String getUniqueNotationNameGen(DTDFile dtdFile) {
        List notations = dtdFile.listDTDNotation();
        return DTDUniqueNameHelper.getUniqueName(notations, "NewNotation");
    }

    protected static String getUniqueAttributeNameGen(DTDElement element) {
        EList attrs = element.getDTDAttribute();
        return DTDUniqueNameHelper.getUniqueName((List)attrs, "NewAttribute");
    }

    protected static String getUniqueNameGen(List objs, String token) {
        int counter = 1;
        boolean uniqueName = false;
        while (!uniqueName) {
            String newName = String.valueOf(token) + new Integer(counter++);
            uniqueName = true;
            for (Object obj : objs) {
                String objName = DTDUniqueNameHelper.getName(obj);
                if (!objName.equals(newName)) continue;
                uniqueName = false;
                break;
            }
            if (!uniqueName) continue;
            return newName;
        }
        return "No Name found";
    }

    protected static String getNameGen(Object obj) {
        if (obj instanceof DTDElement) {
            return ((DTDElement)obj).getName();
        }
        if (obj instanceof DTDEntity) {
            return ((DTDEntity)obj).getName();
        }
        if (obj instanceof DTDNotation) {
            return ((DTDNotation)obj).getName();
        }
        if (obj instanceof DTDAttribute) {
            return ((DTDAttribute)obj).getName();
        }
        return "";
    }
}

