/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.dialogs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.xwt.internal.utils.LoggerManager;
import org.eclipse.xwt.tools.ui.designer.wizards.AccessorConfigureInfo;
import org.eclipse.xwt.tools.ui.designer.wizards.ExternalizeStringsCommon;

public class AccessorConfigurationDialog
extends StatusDialog {
    private String sourceFolder;
    private String sourcePackage;
    private String className;
    private String propertyFolder;
    private String propertyPackage;
    private String propertyName;
    private Text classNameText;
    private Text sourcePackageText;
    private Text sourceFolderText;
    private Text propertyNameText;
    private Text propertyPackageText;
    private Text propertyFolderText;
    private Button sourcePackagButton;
    private Button chooseClassTypeButton;
    private Button propertyPackagButton;
    private Button choosePropertyTypeButton;
    private Button propertyFolderButton;
    private Label classDefaultLabel;
    private Label propertyDefaultLabel;
    private Label propertyLabel;
    private boolean isError = false;
    private IPackageFragmentRoot classRoot;
    private IPackageFragmentRoot propertyRoot;
    private IStatus fLastStatus;
    private IPackageFragment propertyFragment;
    private IPackageFragment classFragment;
    private AccessorConfigureInfo info;
    Object[] propertyFileNames;
    Object[] classFileNames;

    public AccessorConfigurationDialog(Shell parent, AccessorConfigureInfo info) {
        super(parent);
        this.info = info;
    }

    protected Control createDialogArea(Composite ancestor) {
        if (this.info.getClassRoot() != null) {
            this.classRoot = this.info.getClassRoot();
            this.classFragment = this.classRoot.getPackageFragment(this.info.getSourcePackage());
            this.classFileNames = this.createFileListInput(".java", this.classFragment);
        }
        if (this.info.getPropertyRoot() != null) {
            this.propertyRoot = this.info.getPropertyRoot();
            this.propertyFragment = this.propertyRoot.getPackageFragment(this.info.getPropertyPackage());
            this.propertyFileNames = this.createFileListInput(".properties", this.propertyFragment);
        }
        Composite parent = (Composite)super.createDialogArea(ancestor);
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        String resourceLabelContens = "Resource bundle accessor class(will be created if it does not exist):";
        this.createClassLabel(container, resourceLabelContens);
        this.createClassFolderField(container);
        this.createClassPackageField(container);
        this.createClassNameField(container);
        this.drawLine(container);
        String propertyLabelContens = "Property file location and name:";
        this.createPropertyLabel(container, propertyLabelContens);
        this.createPropertyFolderField(container);
        this.createPropertyPackageField(container);
        this.createPropertyNameField(container);
        this.getExistPropertyFile();
        return parent;
    }

    private void drawLine(Composite container) {
        Label hLabel = new Label(container, 258);
        GridData gridData = new GridData(256);
        gridData.horizontalSpan = 3;
        gridData.heightHint = 20;
        hLabel.setLayoutData((Object)gridData);
    }

    private void createClassLabel(Composite container, String labelContents) {
        Label classLabel = new Label(container, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.heightHint = 20;
        classLabel.setText(labelContents);
        classLabel.setLayoutData((Object)gridData);
    }

    private void createPropertyLabel(Composite container, String labelContents) {
        this.propertyLabel = new Label(container, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        gridData.heightHint = 20;
        gridData.widthHint = 350;
        this.propertyLabel.setText(labelContents);
        this.propertyLabel.setLayoutData((Object)gridData);
    }

    private void createClassFolderField(Composite container) {
        Label sourceFolderLabel = new Label(container, 0);
        GridData gridData = new GridData();
        sourceFolderLabel.setText("Source folder:");
        sourceFolderLabel.setLayoutData((Object)gridData);
        this.sourceFolderText = new Text(container, 2048);
        gridData = new GridData(768);
        this.sourceFolderText.setLayoutData((Object)gridData);
        this.sourceFolderText.setText(this.info.getSourceFolder());
        this.sourceFolder = this.sourceFolderText.getText();
        this.sourceFolderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AccessorConfigurationDialog.this.sourceFolder = AccessorConfigurationDialog.this.sourceFolderText.getText();
                AccessorConfigurationDialog.this.setNewRoot("/" + AccessorConfigurationDialog.this.sourceFolder, true);
                AccessorConfigurationDialog.this.checkFomat();
            }
        });
        Button sourceFolderButton = new Button(container, 8);
        sourceFolderButton.setText("Browse...");
        sourceFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccessorConfigurationDialog.this.classRoot = AccessorConfigurationDialog.this.chooseSourceContainer(AccessorConfigurationDialog.this.classRoot);
                IPath path = AccessorConfigurationDialog.this.classRoot.getPath();
                AccessorConfigurationDialog.this.sourceFolderText.setText(path.toString().substring(1));
            }
        });
    }

    private void createClassPackageField(Composite container) {
        Label sourcePackageLabel = new Label(container, 0);
        GridData gridData = new GridData();
        sourcePackageLabel.setText("Package:");
        sourcePackageLabel.setLayoutData((Object)gridData);
        Composite classPackageField = new Composite(container, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        classPackageField.setLayout((Layout)layout);
        gridData = new GridData(768);
        classPackageField.setLayoutData((Object)gridData);
        this.sourcePackageText = new Text(classPackageField, 2048);
        gridData = new GridData(768);
        this.sourcePackageText.setLayoutData((Object)gridData);
        this.sourcePackageText.setText(this.info.getSourcePackage());
        this.sourcePackage = this.sourcePackageText.getText();
        this.sourcePackageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AccessorConfigurationDialog.this.sourcePackage = AccessorConfigurationDialog.this.sourcePackageText.getText();
                AccessorConfigurationDialog.this.checkFomat();
                if (AccessorConfigurationDialog.this.getSourcePackage() == null || "".equals(AccessorConfigurationDialog.this.getSourcePackage())) {
                    AccessorConfigurationDialog.this.classDefaultLabel.setText("(default)");
                }
            }
        });
        this.classDefaultLabel = new Label(classPackageField, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.classDefaultLabel.setLayoutData((Object)gridData);
        this.sourcePackagButton = new Button(container, 8);
        this.sourcePackagButton.setText("Browse...");
        this.sourcePackagButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Widget widget = e.widget;
                AccessorConfigurationDialog.this.choosePackage(widget, AccessorConfigurationDialog.this.classRoot);
            }
        });
    }

    private void createClassNameField(Composite container) {
        Label classNameLabel = new Label(container, 0);
        GridData gridData = new GridData();
        classNameLabel.setText("Class name:");
        classNameLabel.setLayoutData((Object)gridData);
        this.classNameText = new Text(container, 2048);
        gridData = new GridData(768);
        this.classNameText.setLayoutData((Object)gridData);
        this.classNameText.setText(this.info.getClassName());
        this.className = this.classNameText.getText();
        this.classNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AccessorConfigurationDialog.this.className = AccessorConfigurationDialog.this.classNameText.getText();
                AccessorConfigurationDialog.this.checkFomat();
            }
        });
        this.chooseClassTypeButton = new Button(container, 8);
        this.chooseClassTypeButton.setText("Browse...");
        this.chooseClassTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccessorConfigurationDialog.this.browseForAccessorClass(AccessorConfigurationDialog.this.classRoot);
            }
        });
    }

    private void createPropertyFolderField(Composite container) {
        Label propertyFolderLabel = new Label(container, 0);
        GridData gridData = new GridData();
        propertyFolderLabel.setText("Source folder:");
        propertyFolderLabel.setLayoutData((Object)gridData);
        this.propertyFolderText = new Text(container, 2048);
        gridData = new GridData(768);
        this.propertyFolderText.setLayoutData((Object)gridData);
        this.propertyFolderText.setText(this.info.getPropertyFolder());
        this.propertyFolder = this.propertyFolderText.getText();
        this.propertyFolderText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AccessorConfigurationDialog.this.propertyFolder = AccessorConfigurationDialog.this.propertyFolderText.getText();
                AccessorConfigurationDialog.this.setNewRoot("/" + AccessorConfigurationDialog.this.propertyFolder, false);
                AccessorConfigurationDialog.this.checkFomat();
            }
        });
        this.propertyFolderButton = new Button(container, 8);
        this.propertyFolderButton.setText("Browse...");
        this.propertyFolderButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccessorConfigurationDialog.this.propertyRoot = AccessorConfigurationDialog.this.chooseSourceContainer(AccessorConfigurationDialog.this.propertyRoot);
                IPath path = AccessorConfigurationDialog.this.propertyRoot.getPath();
                AccessorConfigurationDialog.this.propertyFolderText.setText(path.toString().substring(1));
            }
        });
    }

    private void createPropertyPackageField(Composite container) {
        Label propertyPackageLabel = new Label(container, 0);
        GridData gridData = new GridData();
        propertyPackageLabel.setText("Package:");
        propertyPackageLabel.setLayoutData((Object)gridData);
        Composite propertyPackageField = new Composite(container, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        propertyPackageField.setLayout((Layout)layout);
        gridData = new GridData(768);
        propertyPackageField.setLayoutData((Object)gridData);
        this.propertyPackageText = new Text(propertyPackageField, 2048);
        gridData = new GridData(768);
        this.propertyPackageText.setLayoutData((Object)gridData);
        this.propertyPackageText.setText(this.info.getPropertyPackage());
        this.propertyPackage = this.propertyPackageText.getText();
        this.propertyPackageText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AccessorConfigurationDialog.this.propertyPackage = AccessorConfigurationDialog.this.propertyPackageText.getText();
                AccessorConfigurationDialog.this.checkFomat();
                if (AccessorConfigurationDialog.this.getPropertyPackage() == null || "".equals(AccessorConfigurationDialog.this.getPropertyPackage())) {
                    AccessorConfigurationDialog.this.propertyDefaultLabel.setText("(default)");
                }
            }
        });
        this.propertyDefaultLabel = new Label(propertyPackageField, 0);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.propertyDefaultLabel.setLayoutData((Object)gridData);
        this.propertyPackagButton = new Button(container, 8);
        this.propertyPackagButton.setText("Browse...");
        this.propertyPackagButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Widget widget = e.widget;
                AccessorConfigurationDialog.this.choosePackage(widget, AccessorConfigurationDialog.this.propertyRoot);
            }
        });
    }

    private void createPropertyNameField(Composite container) {
        Label propertyNameLabel = new Label(container, 0);
        GridData gridData = new GridData();
        propertyNameLabel.setText("Porperty File name:");
        propertyNameLabel.setLayoutData((Object)gridData);
        this.propertyNameText = new Text(container, 2048);
        gridData = new GridData(768);
        this.propertyNameText.setLayoutData((Object)gridData);
        this.propertyNameText.setText(this.info.getPropertyName());
        this.propertyName = this.propertyNameText.getText();
        this.propertyNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AccessorConfigurationDialog.this.propertyName = AccessorConfigurationDialog.this.propertyNameText.getText();
                AccessorConfigurationDialog.this.checkFomat();
            }
        });
        this.choosePropertyTypeButton = new Button(container, 8);
        this.choosePropertyTypeButton.setText("Browse...");
        this.choosePropertyTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccessorConfigurationDialog.this.browseForPropertyFile();
            }
        });
    }

    protected void browseForAccessorClass(IPackageFragmentRoot root) {
        IType selectedType;
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        IJavaSearchScope scope = root != null ? SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{root}) : SearchEngine.createWorkspaceScope();
        FilteredTypesSelectionDialog dialog = new FilteredTypesSelectionDialog(this.getShell(), false, (IRunnableContext)service, scope, 5);
        dialog.setTitle("Choose a Type");
        dialog.setInitialPattern("*Messages");
        this.classFileNames = this.createFileListInput(".java", this.classFragment);
        if (dialog.open() == 0 && (selectedType = (IType)dialog.getFirstResult()) != null) {
            this.classNameText.setText(selectedType.getElementName());
        }
    }

    private void browseForPropertyFile() {
        IFile selectedFile;
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider());
        dialog.setIgnoreCase(false);
        dialog.setTitle("Choose the property file:");
        dialog.setMessage("Choose the property file:");
        dialog.setElements(this.createFileListInput(".properties", this.propertyFragment));
        this.propertyFileNames = this.createFileListInput(".properties", this.propertyFragment);
        dialog.setFilter("*properties");
        if (dialog.open() == 0 && (selectedFile = (IFile)dialog.getFirstResult()) != null) {
            this.propertyNameText.setText(selectedFile.getName().substring(0, selectedFile.getName().lastIndexOf(".properties")));
        }
    }

    private Object[] createFileListInput(String extension, IPackageFragment fragment) {
        try {
            if (fragment == null) {
                return new Object[0];
            }
            ArrayList<Object> result = new ArrayList<Object>(1);
            if (".java".equals(extension)) {
                Object[] java = fragment.getChildren();
                return java;
            }
            Object[] nonjava = fragment.getNonJavaResources();
            int i = 0;
            while (i < nonjava.length) {
                if (AccessorConfigurationDialog.isAlrightFile(nonjava[i], extension)) {
                    result.add(nonjava[i]);
                }
                ++i;
            }
            return result.toArray();
        }
        catch (JavaModelException e) {
            return new Object[0];
        }
    }

    private static boolean isAlrightFile(Object o, String extension) {
        if (!(o instanceof IFile)) {
            return false;
        }
        IFile file = (IFile)o;
        return extension.equals(String.valueOf('.') + file.getFileExtension());
    }

    private void setRootNull(boolean isClass) {
        if (isClass) {
            this.classRoot = null;
        } else {
            this.propertyRoot = null;
        }
    }

    private void setNewRoot(String path, boolean isClass) {
        int start = path.indexOf("/");
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
        if (path.length() == 0 || container == null || (container.getType() & 6) == 0) {
            this.setRootNull(isClass);
        } else if (path.indexOf("/", path.indexOf("/", start + 1) + 1) != -1 || path.indexOf("\\") != -1) {
            this.setRootNull(isClass);
        } else {
            try {
                IFile file = ExternalizeStringsCommon.getIFile(path, "");
                IJavaProject javaProject = JavaCore.create((IProject)file.getProject());
                IPackageFragmentRoot[] fragmentRoot = javaProject.getAllPackageFragmentRoots();
                int i = 0;
                while (i < fragmentRoot.length) {
                    if (fragmentRoot[i].getResource() != null) {
                        if (isClass) {
                            this.classRoot = fragmentRoot[i];
                        } else {
                            this.propertyRoot = fragmentRoot[i];
                        }
                        break;
                    }
                    ++i;
                }
            }
            catch (CoreException e) {
                LoggerManager.log((Throwable)e);
            }
        }
    }

    protected void choosePackage(Widget widget, IPackageFragmentRoot root) {
        Object[] packages = null;
        try {
            if (root != null && root.exists()) {
                packages = root.getChildren();
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        if (packages == null) {
            packages = new IJavaElement[]{};
        }
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)new JavaElementLabelProvider(18));
        dialog.setIgnoreCase(true);
        dialog.setTitle("Package Selection");
        dialog.setMessage("Choose the destination package:");
        dialog.setElements(packages);
        if (dialog.open() == 0) {
            IPackageFragment fragment = (IPackageFragment)dialog.getFirstResult();
            if (widget.equals(this.sourcePackagButton)) {
                this.sourcePackageText.setText(fragment.getElementName());
                this.classFragment = fragment;
            } else if (widget.equals(this.propertyPackagButton)) {
                this.propertyPackageText.setText(fragment.getElementName());
                this.propertyFragment = fragment;
            }
        }
    }

    private IPackageFragmentRoot chooseSourceContainer(IPackageFragmentRoot root) {
        Class[] acceptedClasses = new Class[]{IPackageFragmentRoot.class, IJavaProject.class};
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, false){

            public boolean isSelectedValid(Object element) {
                try {
                    if (element instanceof IJavaProject) {
                        IJavaProject jproject = (IJavaProject)element;
                        IPath path = jproject.getProject().getFullPath();
                        return jproject.findPackageFragmentRoot(path) != null;
                    }
                    if (element instanceof IPackageFragmentRoot) {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    return true;
                }
                catch (JavaModelException e) {
                    JavaPlugin.log((IStatus)e.getStatus());
                    return false;
                }
            }
        };
        acceptedClasses = new Class[]{IJavaModel.class, IPackageFragmentRoot.class, IJavaProject.class};
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses){

            public boolean select(Viewer viewer, Object parent, Object element) {
                if (element instanceof IPackageFragmentRoot) {
                    try {
                        return ((IPackageFragmentRoot)element).getKind() == 1;
                    }
                    catch (JavaModelException e) {
                        JavaPlugin.log((IStatus)e.getStatus());
                        return false;
                    }
                }
                return super.select(viewer, parent, element);
            }
        };
        StandardJavaElementContentProvider provider = new StandardJavaElementContentProvider();
        JavaElementLabelProvider labelProvider = new JavaElementLabelProvider(18);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)labelProvider, (ITreeContentProvider)provider);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setComparator((ViewerComparator)new JavaElementComparator());
        dialog.setTitle("Source Folder Selection");
        dialog.setMessage("Choose a source folder:");
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaProject) {
                IJavaProject jproject = (IJavaProject)element;
                return jproject.getPackageFragmentRoot((IResource)jproject.getProject());
            }
            if (element instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)element;
            }
            return null;
        }
        return root;
    }

    private void checkFilePath(String path, boolean isPackage, boolean isClass) {
        int start;
        IResource container = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(path));
        if (path.length() == 0 && !isPackage) {
            this.updateStatus("Both sources folder must be specified");
            return;
        }
        if (container == null || (container.getType() & 6) == 0) {
            if (isPackage && !"".equals(path)) {
                this.updateStatus("The apecified package for the resource bundle is invalid.");
                return;
            }
            if (!isPackage) {
                this.updateStatus("Both source folders must exist");
                return;
            }
        }
        if (!container.isAccessible()) {
            this.updateStatus("Both projects must be writable");
            return;
        }
        if (!(isPackage || path.indexOf("/", path.indexOf("/", (start = path.indexOf("/")) + 1) + 1) == -1 && path.indexOf("\\") == -1)) {
            this.updateStatus("Both source folders must exist");
            this.setRootNull(isClass);
            return;
        }
        this.updateStatus("");
    }

    private void checkPackage(String path, String packageName, boolean isProperty) {
        if ((packageName == null || packageName.length() == 0) && isProperty) {
            this.updateStatus("Incorret package.");
            return;
        }
        if (packageName.indexOf("/") != -1 || packageName.indexOf("\\") != -1) {
            this.updateStatus("The apecified package for the resource bundle is invalid.");
            return;
        }
        this.checkFilePath(path, true, !isProperty);
    }

    private void checkFileName() {
        String regex = "^([_|a-zA-Z])[_\\w]*$";
        if ("".equals(this.getClassName())) {
            this.updateStatus("The class name must be specified.");
        } else {
            Matcher matcher = Pattern.compile(regex).matcher(this.className);
            if (!matcher.find()) {
                this.updateStatus("The type name\"" + this.className + "\"is not a valid indentifier.");
            } else {
                this.updateStatus("");
            }
        }
    }

    private void checkFomat() {
        this.checkFilePath("/" + this.sourceFolder, false, true);
        if (this.isError) {
            return;
        }
        this.checkFilePath("/" + this.propertyFolder, false, false);
        if (this.isError) {
            return;
        }
        this.checkPackage(this.getClassFilePath(), this.getSourcePackage(), false);
        if (this.isError) {
            return;
        }
        this.checkFileName();
        if (this.isError) {
            return;
        }
        this.checkPackage(this.getPropertyFilePath(), this.getPropertyPackage(), true);
        if (this.isError) {
            return;
        }
        if ("".equals(this.getPropertyName())) {
            this.updateStatus("The Property File Name must be specified. ");
        } else {
            this.updateStatus("");
            this.getExistPropertyFile();
        }
    }

    private void updateStatus(String message) {
        if (message != null && !"".equals(message)) {
            this.isError = true;
            this.fLastStatus = new Status(4, "org.eclipse.jdt.core", -1, message, null);
            this.setPropertyFieldEnable(true);
        } else {
            this.isError = false;
            this.fLastStatus = new Status(0, "org.eclipse.jface", 0, "", null);
        }
        this.updateStatus(this.fLastStatus);
    }

    private void getExistPropertyFile() {
        try {
            IFile file = ExternalizeStringsCommon.getIFile(this.getClassFilePath(), String.valueOf(this.className) + ".java");
            int keyBegin = this.getClassFilePath().indexOf("/", 1) + 1;
            int keyEnd = this.getClassFilePath().indexOf("/", keyBegin + 1);
            String sourceKey = this.getClassFilePath().substring(keyBegin, keyEnd);
            if (file.exists()) {
                IJavaProject javaProject = JavaCore.create((IProject)file.getProject());
                String propertyFolder = String.valueOf(javaProject.getElementName()) + "/" + sourceKey;
                StringBuffer contents = ExternalizeStringsCommon.getHistoryContents(file);
                String findKey = "BUNDLE_NAME";
                int index = contents.toString().indexOf(findKey);
                int start = contents.indexOf("\"", index);
                int end = contents.indexOf("\"", start + 1);
                String path = contents.substring(start + 1, end);
                String propertyPackage = path.substring(0, path.lastIndexOf("."));
                String propertyName = path.substring(path.lastIndexOf(".") + 1);
                if (!propertyFolder.equals(this.propertyFolderText.getText())) {
                    this.propertyFolderText.setText(propertyFolder);
                }
                if (!propertyPackage.equals(this.propertyPackageText.getText())) {
                    this.propertyPackageText.setText(propertyPackage);
                }
                if (!propertyName.equals(this.propertyNameText.getText())) {
                    this.propertyNameText.setText(propertyName);
                }
                this.setPropertyFieldEnable(false);
            } else {
                this.setPropertyFieldEnable(true);
            }
        }
        catch (CoreException e) {
            LoggerManager.log((Throwable)e);
        }
        catch (IOException e) {
            LoggerManager.log((Throwable)e);
        }
    }

    protected void okPressed() {
        if (this.checkFileExist(this.getClassName(), ".java", this.classFileNames, this.getClassFilePath())) {
            return;
        }
        if (this.checkFileExist(this.getPropertyName(), ".properties", this.propertyFileNames, this.getPropertyFilePath())) {
            return;
        }
        this.setReturnCode(0);
        this.close();
    }

    private boolean checkFileExist(String name, String extension, Object[] names, String path) {
        Object[] fileNames = names;
        int i = 0;
        while (i < fileNames.length) {
            String fileExist = ".java".equals(extension) ? ((IJavaElement)fileNames[i]).getElementName() : ((IFile)fileNames[i]).getName();
            String fileExistName = fileExist.substring(0, fileExist.lastIndexOf(extension));
            if (!name.equals(fileExistName) && name.toLowerCase().equals(fileExistName.toLowerCase())) {
                this.showFileExistDialog(name, extension, path);
                return true;
            }
            ++i;
        }
        return false;
    }

    private void showFileExistDialog(String name, String extension, String path) {
        String dialogMessage = "File '" + path.replace(".", "/") + "/" + name + extension + "' already exist with different case.";
        String[] dialogButtonLabels = new String[]{"Ok"};
        MessageDialog messageDialog = new MessageDialog(this.getShell(), "Configure Accessor Class", null, dialogMessage, 1, dialogButtonLabels, 1);
        messageDialog.open();
    }

    private void setPropertyFieldEnable(boolean b) {
        String propertyLabelContens = b ? "Property file location and name:" : "Property file location and name(Default exist file):";
        if (!propertyLabelContens.equals(this.propertyLabel.getText())) {
            this.propertyLabel.setText(propertyLabelContens);
        }
        this.propertyFolderButton.setEnabled(b);
        this.propertyPackagButton.setEnabled(b);
        this.choosePropertyTypeButton.setEnabled(b);
        this.propertyFolderText.setEnabled(b);
        this.propertyPackageText.setEnabled(b);
        this.propertyNameText.setEnabled(b);
    }

    public IPackageFragmentRoot getclassRoot() {
        return this.classRoot;
    }

    public String getClassFilePath() {
        return "/" + this.sourceFolder + "/" + this.getSourcePackage().replace(".", "/");
    }

    public String getSourceFolder() {
        return this.sourceFolder;
    }

    public String getSourcePackage() {
        return this.sourcePackage;
    }

    public String getClassName() {
        return this.className;
    }

    public IPackageFragmentRoot getPropertyRoot() {
        return this.propertyRoot;
    }

    public String getPropertyFolder() {
        return this.propertyFolder;
    }

    public String getPropertyFilePath() {
        return "/" + this.propertyFolder + "/" + this.getPropertyPackage().replace(".", "/");
    }

    public String getPropertyPackage() {
        return this.propertyPackage;
    }

    public String getPropertyName() {
        return this.propertyName;
    }
}

