/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.loader;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.xwt.tools.ui.xaml.XamlAttribute;
import org.eclipse.xwt.tools.ui.xaml.XamlElement;
import org.eclipse.xwt.tools.ui.xaml.XamlNode;

public class NodesSorter {
    public static List<XamlNode> sortWithAttr(XamlNode[] sourceArray, String attrName) {
        return NodesSorter.sortWithAttr(sourceArray, new AttrComparator(attrName), attrName);
    }

    public static List<XamlNode> sortWithAttr(XamlNode[] sourceArray, Comparator<XamlElement> comparator, String attrName) {
        XamlElement columnElement;
        LinkedList<XamlNode> columnsList = new LinkedList<XamlNode>();
        XamlElement xamlElement = sourceArray;
        int n = ((XamlNode[])xamlElement).length;
        int n2 = 0;
        while (n2 < n) {
            XamlNode column = xamlElement[n2];
            columnElement = (XamlElement)column;
            XamlAttribute indexAttr = columnElement.getAttribute(attrName, "http://www.eclipse.org/xwt/presentation");
            if (indexAttr == null) {
                columnsList.add(column);
            }
            ++n2;
        }
        LinkedList<XamlElement> tempList = new LinkedList<XamlElement>();
        columnElement = sourceArray;
        int n3 = ((XamlElement)columnElement).length;
        n = 0;
        while (n < n3) {
            XamlElement column = columnElement[n];
            XamlElement columnElement2 = column;
            XamlAttribute indexAttr = columnElement2.getAttribute(attrName, "http://www.eclipse.org/xwt/presentation");
            if (indexAttr != null) {
                tempList.add(columnElement2);
            }
            ++n;
        }
        if (comparator == null) {
            comparator = new AttrComparator(attrName);
        }
        Collections.sort(tempList, comparator);
        for (XamlElement columnElement3 : tempList) {
            XamlAttribute indexAttr = columnElement3.getAttribute(attrName, "http://www.eclipse.org/xwt/presentation");
            try {
                int index = Integer.parseInt(indexAttr.getValue());
                columnsList.add(index, (XamlNode)columnElement3);
            }
            catch (Exception e) {
                columnsList.add(columnsList.size(), (XamlNode)columnElement3);
            }
        }
        return columnsList;
    }

    private static class AttrComparator
    implements Comparator<XamlElement>,
    Serializable {
        private static final long serialVersionUID = 5974723422066058166L;
        private String attrName;

        public AttrComparator(String attrName) {
            this.attrName = attrName;
        }

        @Override
        public int compare(XamlElement e1, XamlElement e2) {
            XamlAttribute attr1 = e1.getAttribute(this.attrName, "http://www.eclipse.org/xwt/presentation");
            XamlAttribute attr2 = e2.getAttribute(this.attrName, "http://www.eclipse.org/xwt/presentation");
            String compare1 = attr1.getValue();
            String compare2 = attr2.getValue();
            if (compare1 == null || compare2 == null) {
                return 0;
            }
            try {
                int index1 = Integer.parseInt(compare1);
                int index2 = Integer.parseInt(compare2);
                return index1 > index2 ? 1 : -1;
            }
            catch (Exception e) {
                return compare1.compareTo(compare2);
            }
        }
    }
}

