/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xwt.tools.ui.designer.parts.figures;

import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xwt.tools.ui.designer.parts.MenuEditPart;
import org.eclipse.xwt.tools.ui.designer.parts.figures.Expandable;

public class MenuFigure
extends Figure
implements Expandable {
    private static final int HEIGHT_HINT = 4;
    private static final int WIDTH_HINT = 40;
    private MenuEditPart host;
    private Label initLabel = new Label(" (New Menu) ");

    public MenuFigure(MenuEditPart host) {
        this.host = host;
        this.initLabel.setFont(Display.getCurrent().getSystemFont());
        this.setBackgroundColor(ColorConstants.white);
        this.setForegroundColor(ColorConstants.gray);
        MenuLayout manager = new MenuLayout();
        manager.setStretchMinorAxis(true);
        manager.setHorizontalSpacing(4);
        manager.setVerticalSpacing(2);
        manager.setMinorAlignment(0);
        this.setLayoutManager((LayoutManager)manager);
        this.add((IFigure)this.initLabel);
    }

    public void add(IFigure figure, Object constraint, int index) {
        if (figure != null && figure != this.initLabel && this.initLabel.getParent() == this) {
            this.remove((IFigure)this.initLabel);
        }
        super.add(figure, constraint, index);
    }

    protected void paintFigure(Graphics graphics) {
        Rectangle r = this.getBounds().getCopy();
        int x = r.x;
        int y = r.y;
        int w = r.width - 1;
        int h = r.height - 1;
        graphics.fillRectangle(r);
        graphics.drawRectangle(new Rectangle(x, y, w, h));
    }

    @Override
    public void collapse() {
        this.setVisible(false);
    }

    @Override
    public void expand() {
        List children = this.getChildren();
        int width = 0;
        int height = 0;
        for (IFigure figure : children) {
            Dimension size = figure.getPreferredSize();
            width = Math.max(width, size.width);
            height += size.height;
            figure.setBackgroundColor(ColorConstants.white);
            figure.setForegroundColor(ColorConstants.white);
        }
        if (width > 0 && height > 0) {
            this.setSize(new Dimension(width + 40, height + 4));
            this.layout();
            this.setVisible(true);
        }
        this.repaint();
    }

    @Override
    public GraphicalEditPart getHost() {
        return this.host;
    }

    private static class MenuLayout
    extends ToolbarLayout {
        private int horizontalSpacing = 0;
        private int verticalSpacing = 0;

        public MenuLayout() {
            this.setVertical(true);
        }

        public void layout(IFigure parent) {
            super.layout(parent);
            List children = parent.getChildren();
            for (IFigure child : children) {
                Rectangle r = child.getBounds().getCopy();
                int height = r.height - this.getVerticalSpacing() * 2;
                if (height < 1) {
                    height = 1;
                }
                child.setBounds(new Rectangle(r.x + this.getHorizontalSpacing(), r.y + this.getVerticalSpacing(), r.width - this.getHorizontalSpacing() * 2, height));
            }
        }

        public void setHorizontalSpacing(int horizontalSpacing) {
            this.horizontalSpacing = horizontalSpacing;
        }

        public int getHorizontalSpacing() {
            return this.horizontalSpacing;
        }

        public void setVerticalSpacing(int verticalSpacing) {
            this.verticalSpacing = verticalSpacing;
        }

        public int getVerticalSpacing() {
            return this.verticalSpacing;
        }
    }
}

