/******************************************************************************
 *{@C
 *      Copyright:      2005-2010 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D
 *      Filename:       tcl3dConstHash.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file to place constant values into a
 *                      Tcl hash table. 
 *
 *****************************************************************************/

%{

static int My_GetConst (Tcl_Interp *interp, Tcl_Obj *obj, long *valPtr) {
    int     len;
    Tcl_Obj *foundObj = NULL;
    char *str = Tcl_GetStringFromObj (obj, &len);
    foundObj = SWIG_GetConstant (str);
    if (!foundObj) {
        return Tcl_GetLongFromObj (interp, obj, valPtr);
    }
    return Tcl_GetLongFromObj (interp, foundObj, valPtr);
}

%}

// Change input handling to look for names for the specified types

// OPA TODO Find a way to put the Cg and OSG specific types into their
// sub-directories.

%typemap(in) GLboolean, GLenum, GLbitfield, CGenum, CGGLenum, CGprofile, CGtype, CGresource, CGerror, osg::StateAttribute::GLMode, osg::StateAttribute::GLModeValue, osg::StateAttribute::OverrideValue, osg::Fog::Mode
{
    long temp; 
    if (My_GetConst (interp, $input, &temp) == TCL_ERROR) {
        return TCL_ERROR;
    } else {
        $1 = ($type) temp;
    }
}
