/******************************************************************************
 *{@C
 *      Copyright:      2005-2010 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOde
 *      Filename:       ode.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG module for wrapping the ODE library.
 *
 *****************************************************************************/

%module ode

%{
#if defined (WIN32)
#include <windows.h>
#include <wingdi.h>
#endif
#include "ode.h"
%}

%include tcl3dDefines.i

// ODE uses single precision floating point by default.

%baseTypeVector(float,dReal)

// %apply dReal *OUTPUT { dVector3 gravity };

// These functions are internal functions of ODE, but listed in the common.h
// interface file. Do NOT wrap them, to avoid unresolved external references.

%ignore dGeomMoved;
%ignore dGeomGetBodyNext;

// The ODE config file makes some assumptions about defined macros, whic are 
// not defined with swig. So we define them here, and undefine them after 
// having read the config file, because otherwise FLT_MAX would not be a real
// value, but empty, which causes a compile error.

#if defined (WIN32)
#define _MSC_VER
#endif
#define FLT_MAX

%include "config.h"

#if defined (WIN32)
#undef _MSC_VER
#endif
#undef FLT_MAX

%include "common.h"
%include "contact.h"
%include "odemath.h"
%include "matrix.h"
%include "timer.h"
%include "rotation.h"
%include "mass.h"
%include "misc.h"
%include "objects.h"
%include "collision.h"
%include "collision_space.h"
