set inFile  "GLSpec/glExtUrlList.html"
set outFile "GLSpec/glExtUrlList.txt"

set inFp  [open $inFile  "r"]
set outFp [open $outFile "w"]

set numExts 0
while { [gets $inFp line] >= 0 } {
    set indRef [string first "a href" $line]
    if { $indRef >= 0 } {
        set indUrlStart [string first "=" $line $indRef]
        set indUrlStop  [string first ">" $line $indRef]
        set indNameStop [string first "<" $line $indRef]
        set url [string range $line [expr $indUrlStart +1] [expr $indUrlStop -1]]
        set url [string trim $url "\""]
        if { [string first "http" $url] < 0 } {
            # OpenGL.org switched to relative pathnames. So prepend the domain.
            set url [format "%s%s" "http://www.opengl.org/" $url]
        }
        set extName [string range $line [expr $indUrlStop +1] [expr $indNameStop -1]]
        puts $outFp "$extName $url"
        incr numExts
    }
}
puts "Found $numExts extensions"

close $inFp
close $outFp

exit 0
