/******************************************************************************
 *{@C
 *      Copyright:      2008-2010 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOgl
 *      Filename:       tcl3dUtilFractal.h
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Declarations for functions to create fractal images.
 *
 *****************************************************************************/

#ifndef __TCL3D_UTIL_FRACTAL_H__
#define __TCL3D_UTIL_FRACTAL_H__

#ifdef __cplusplus
   extern "C" {
#endif

int tcl3dUtilFractalToPhoto (
        Tcl_Interp *interp, const char *photoName, const char *coloringMethod,
        int width, int height, 
        double cx, double cy, double size,
        int numIter, double bandFrequ,
        unsigned char br, unsigned char bg, unsigned char bb,
        unsigned char ir, unsigned char ig, unsigned char ib,
        unsigned char or, unsigned char og, unsigned char ob);

#ifdef __cplusplus
   }
#endif

#endif /* __TCL3D_UTIL_FRACTAL_H__ */
