/******************************************************************************
 *{@C
 *      Copyright:      2005-2010 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on 
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOgl
 *      Filename:       tcl3dUtilPortable.h
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Functions to convert integer and floating point
 *                      numbers between the processor's data format and
 *                      a machine-independent representation.
 *
 *****************************************************************************/

#ifndef __TCL3D_UTIL_PORTABLE_H__
#define __TCL3D_UTIL_PORTABLE_H__

#include <GL/glew.h>

#ifdef __cplusplus
   extern "C" {
#endif

    int tcl3dIsIntel (void);

    void tcl3dGLbyteToByte   (GLbyte x,   GLbyte buf[1]);
    void tcl3dGLubyteToByte  (GLubyte x,  GLbyte buf[1]);
    void tcl3dGLshortToByte  (GLshort x,  GLbyte buf[2]);
    void tcl3dGLushortToByte (GLushort x, GLbyte buf[2]);
    void tcl3dGLintToByte    (GLint x,    GLbyte buf[4]);
    void tcl3dGLuintToByte   (GLuint x,   GLbyte buf[4]);
    void tcl3dGLfloatToByte  (GLfloat x,  GLbyte buf[4]);
    void tcl3dGLfloatTo3Byte (GLfloat x,  GLbyte buf[3]);
    void tcl3dGLfloatTo2Byte (GLfloat x,  GLbyte buf[2]);
    void tcl3dGLdoubleToByte (GLdouble x, GLbyte buf[8]);

    GLbyte   tcl3dByteToGLbyte   (const GLbyte buf[1]);
    GLubyte  tcl3dByteToGLubyte  (const GLbyte buf[1]);
    GLshort  tcl3dByteToGLshort  (const GLbyte buf[2]);
    GLushort tcl3dByteToGLushort (const GLbyte buf[2]);
    GLint    tcl3dByteToGLint    (const GLbyte buf[4]);
    GLuint   tcl3dByteToGLuint   (const GLbyte buf[4]);
    GLfloat  tcl3dByteToGLfloat  (const GLbyte buf[4]);
    GLfloat  tcl3d3ByteToGLfloat (const GLbyte buf[3]);
    GLfloat  tcl3d2ByteToGLfloat (const GLbyte buf[2]);
    GLdouble tcl3dByteToGLdouble (const GLbyte buf[8]);

#ifdef __cplusplus
   }
#endif

#endif /* __TCL3D_UTIL_PORTABLE_H__ */
