/******************************************************************************
 *{@C
 *      Copyright:      2005-2010 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOgl
 *      Filename:       tcl3dVecMath.h
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    Declarations for OpenGL compatible 
 *                      vector and matrix functions.
 *
 *****************************************************************************/

#ifndef __TCL3D_VECMATH_H__
#define __TCL3D_VECMATH_H__

#ifdef __cplusplus
   extern "C" {
#endif

    /* Vector handling functions. */
    int   tcl3dVec3fCompare (float  *v1, float  *v2, float  delta);
    int   tcl3dVec3dCompare (double *v1, double *v2, double delta);

    void  tcl3dVec3fIdentity (float  *res);
    void  tcl3dVec3dIdentity (double *res);

    void  tcl3dVec3fCopy   (float  *v, float  *res);
    void  tcl3dVec3dCopy   (double *v, double *res);
    void  tcl3dVec3f2Vec3d (float  *v, double *res);
    void  tcl3dVec3d2Vec3f (double *v, float  *res);

    float  tcl3dVec3fLength (float  *v);
    double tcl3dVec3dLength (double *v);

    int   tcl3dVec3fNormalize (float  *v);
    int   tcl3dVec3dNormalize (double *v);

    float  tcl3dVec3fDistance (float  *v1, float  *v2);
    double tcl3dVec3dDistance (double *v1, double *v2);

    float  tcl3dVec3fDotProduct (float  *v1, float  *v2);
    double tcl3dVec3dDotProduct (double *v1, double *v2);

    void  tcl3dVec3fCrossProduct (float  *v1, float  *v2, float  *res);
    void  tcl3dVec3dCrossProduct (double *v1, double *v2, double *res);

    void  tcl3dVec3fAdd (float  *v1, float  *v2, float  *res);
    void  tcl3dVec3dAdd (double *v1, double *v2, double *res);

    void  tcl3dVec3fSubtract (float  *v1, float  *v2, float  *res);
    void  tcl3dVec3dSubtract (double *v1, double *v2, double *res);

    void  tcl3dVec3fScale (float  scalar, float  *v, float  *res);
    void  tcl3dVec3dScale (double scalar, double *v, double *res);

    void  tcl3dVec3fPlaneNormal (float  *p1, float  *p2, float  *p3, float  *res);
    void  tcl3dVec3dPlaneNormal (double *p1, double *p2, double *p3, double *res);

    /* Matrix handling functions. */
    int  tcl3dMatfCompare (float  *m1, float  *m2, float  delta);
    int  tcl3dMatdCompare (double *m1, double *m2, double delta);

    void tcl3dMatfIdentity (float  *res);
    void tcl3dMatdIdentity (double *res);

    void tcl3dMatfCopy  (float  *m, float  *res);
    void tcl3dMatdCopy  (double *m, double *res);
    void tcl3dMatf2Matd (float  *m, double *res);
    void tcl3dMatd2Matf (double *m, float  *res);

    void tcl3dMatfTranslatev (float  *v, float  *res);
    void tcl3dMatdTranslatev (double *v, double *res);

    void tcl3dMatfTranslate (float  tx, float  ty, float  tz, float  *res);
    void tcl3dMatdTranslate (double tx, double ty, double tz, double *res);

    void tcl3dMatfRotate (float  angle, float  *axis, float  *res);
    void tcl3dMatdRotate (double angle, double *axis, double *res);

    void tcl3dMatfRotateX (float  angle, float  *res);
    void tcl3dMatdRotateX (double angle, double *res);

    void tcl3dMatfRotateY (float  angle, float  *res);
    void tcl3dMatdRotateY (double angle, double *res);

    void tcl3dMatfRotateZ (float  angle, float  *res);
    void tcl3dMatdRotateZ (double angle, double *res);

    void tcl3dMatfScalev (float  *v, float  *res);
    void tcl3dMatdScalev (double *v, double *res);

    void tcl3dMatfScale (float  sx, float  sy, float  sz, float  *res);
    void tcl3dMatdScale (double sx, double sy, double sz, double *res);

    void tcl3dMatfTransformPoint (float  *v, float  *m, float  *res);
    void tcl3dMatdTransformPoint (double *v, double *m, double *res);

    void tcl3dMatfTransformVector (float  *v, float  *m, float  *res);
    void tcl3dMatdTransformVector (double *v, double *m, double *res);

    void tcl3dMatfMult (float  *m1, float  *m2, float  *res);
    void tcl3dMatdMult (double *m1, double *m2, double *res);

    void tcl3dMatfInvert (float  *m, float  *res);
    void tcl3dMatdInvert (double *m, double *res);

    void tcl3dMatfTranspose (float  *m, float  *res);
    void tcl3dMatdTranspose (double *m, double *res);

    int  tcl3dMatfGetAngles (float *m, float *res);
    int  tcl3dMatfGetAngles1 (float *m, float *res);

    /* OpenGL compatible matrix handling functions. */
    void tcl3dMultMatrixf  (float  *m, float  *res);
    void tcl3dMultMatrixd  (double *m, double *res);

    void tcl3dRotatef      (float  angle, float  x, float  y, float  z, float  *res);
    void tcl3dRotated      (double angle, double x, double y, double z, double *res);

    void tcl3dScalef       (float  x, float  y, float  z, float  *res);
    void tcl3dScaled       (double x, double y, double z, double *res);

    void tcl3dTranslatef   (float  x, float  y, float  z, float  *res);
    void tcl3dTranslated   (double x, double y, double z, double *res);

    unsigned int tcl3dRoundUpPow2 (unsigned int val);
    unsigned int tcl3dIsPow2 (unsigned int val);

#ifdef __cplusplus
   }
#endif

#endif /* __TCL3D_VECMATH_H__ */
