package require tcl3d

set l [list 1 2 3 4 5 6 7 8 9]
set llen [llength $l]

# tcl3dVectors of type "char" and "unsigned char" are not supported,
# because corresponding typemaps would collide with the standard mapping
# for C strings. Use types GLbyte and GLubyte instead.
set typeList [list             "short"      "int" \
                               "ushort"     "uint" \
                   "GLbyte"    "GLshort"    "GLint" \
                   "GLubyte"   "GLushort"   "GLuint" \
                   "float"     "GLfloat"   "GLclampf" \
                   "double"    "GLdouble"  "GLclampd" \
                   "GLboolean" "GLbitfield" \
                   "GLenum"    "GLsizei" \
             ]


foreach type $typeList {
    puts -nonewline [format "%-10s:" $type] ; flush stdout
    set vec [tcl3dVectorFromList $type $l]
    for { set i 0 } { $i < $llen } { incr i } {
        puts -nonewline " [$vec get $i]"
    }
    puts ""
}

exit
