/******************************************************************************
 *{@C
 *      Copyright:      2009-2010 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOsg
 *      Filename:       osgGA.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file for wrapping the Open Scene Graph library.
 *                      This file does the actual wrapping of OSG module osgGA.
 *
 *****************************************************************************/

%include "osgHeader.i"

%include "osgAnimationHeader.i"
%include "osgGAHeader.i"
%include "osgParticleHeader.i"
%include "osgSimHeader.i"
%include "osgTextHeader.i"
%include "osgUtilHeader.i"

%import "osg.i"

%{

using namespace osg;
using namespace osgGA;

%}

%ignore osgGA::MatrixManipulator::setCoordinateFrameCallback;
%ignore osgGA::MatrixManipulator::getCoordinateFrameCallback;
%ignore osgGA::EventVisitor::setEvents;
%ignore osgGA::EventVisitor::getEvents;

// OPA TODO Had this in, but it does not seem to be necessary.
//%feature("notabstract") osgGA::AnimationPathManipulator;
//%feature("notabstract") osgGA::DriveManipulator;
//%feature("notabstract") osgGA::FlightManipulator;
//%feature("notabstract") osgGA::TerrainManipulator;
//%feature("notabstract") osgGA::TrackballManipulator;
//%feature("notabstract") osgGA::UFOManipulator;

%include osgGA/EventQueue
%include osgGA/EventVisitor

%include osgGA/GUIActionAdapter
%include osgGA/GUIEventAdapter
%include osgGA/GUIEventHandler

// MatrixManipulator must be included first because of containing the
// base class for all other manipulators.
%include osgGA/MatrixManipulator

%include osgGA/AnimationPathManipulator
%include osgGA/DriveManipulator
%include osgGA/FlightManipulator
%include osgGA/KeySwitchMatrixManipulator
%include osgGA/NodeTrackerManipulator
%include osgGA/StateSetManipulator
%include osgGA/TerrainManipulator
%include osgGA/TrackballManipulator
%include osgGA/UFOManipulator

%include osgGA/Version
