/******************************************************************************
 *{@C
 *      Copyright:      2009-2010 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOsg
 *      Filename:       tcl3dOsgCameraCallback.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file for wrapping the Open Scene Graph library.
 *                      This file is responsible to supply Tcl callback
 *                      functions to be used as OSG camera callbacks.
 *
 *                      The macro USE_OSG_IF must be defined at compilation
 *                      time to include the functionality of the OSG library
 *                      into the Tcl3D package.
 *
 *****************************************************************************/

%include tclinterp.i

%ignore tcl3dOsgCameraPreCallback::operator ();
%ignore tcl3dOsgCameraPostCallback::operator ();

%{
    #include <osg/Camera>

    #include <iostream>
    #include <vector>

    class tcl3dOsgCameraPreCallback : public osg::Camera::DrawCallback {
    public:
        tcl3dOsgCameraPreCallback (Tcl_Interp *interp, const osg::Camera *cam);

        void operator () (const osg::Camera &cam) const;

        void setDrawCallback (const std::string &tclProc);

        const std::string& getDrawCallback ();

    private: 
        const osg::Camera *_cam;
        std::string _tclProc;
        Tcl_Interp  *_interp;
    };

    class tcl3dOsgCameraPostCallback : public osg::Camera::DrawCallback {
    public: 
        tcl3dOsgCameraPostCallback (Tcl_Interp *interp, const osg::Camera *cam);

        void operator () (const osg::Camera &cam) const;

        void setDrawCallback (const std::string &tclProc);

        const std::string& getDrawCallback ();

    private: 
        const osg::Camera *_cam;
        std::string _tclProc;
        Tcl_Interp  *_interp;
    };
%}

class tcl3dOsgCameraPreCallback : public osg::Camera::DrawCallback {
public: 
    tcl3dOsgCameraPreCallback (Tcl_Interp *interp, const osg::Camera *cam);

    void operator () (const osg::Camera &cam) const;

    void setDrawCallback (const std::string &tclProc);

    const std::string& getDrawCallback ();

private: 
    const osg::Camera *_cam;
    std::string _tclProc;
    Tcl_Interp  *_interp;
};

class tcl3dOsgCameraPostCallback : public osg::Camera::DrawCallback {
public: 
    tcl3dOsgCameraPostCallback (Tcl_Interp *interp, const osg::Camera *cam);

    void operator () (const osg::Camera &cam) const;

    void setDrawCallback (const std::string &tclProc);

    const std::string& getDrawCallback ();

private: 
    const osg::Camera *_cam;
    std::string _tclProc;
    Tcl_Interp  *_interp;
};

%{

#define DEBUG

tcl3dOsgCameraPreCallback::tcl3dOsgCameraPreCallback (Tcl_Interp *interp, 
                                                      const osg::Camera *cam):
    osg::Camera::DrawCallback (),
    _cam (cam),
    _interp (interp)
{
#ifdef DEBUG
    printf ("tcl3dOsgCameraPreCallback ()"); fflush (stdout);
#endif
}

void tcl3dOsgCameraPreCallback::operator () (const osg::Camera& cam) const
{
    char cmd[256];
    char buf[30];
    char *b = buf;
    const osg::Camera *camPtr = &cam;

    memset (buf, 0, sizeof (buf));

#ifdef DEBUG
    printf ("tcl3dOsgCameraPreCallback::operator ()\n"); fflush (stdout);
#endif

    /* OPA TODO
     * This way of creating a SWIG compatible pointer is a hack and should
     * be improved.
     */
    b = SWIG_PackData (b, &camPtr, sizeof (void *));
    sprintf (cmd, "%.*s _%s_p_%s__%s",
             200, _tclProc.c_str(), buf, cam.libraryName(), cam.className());
    if (Tcl_Eval (_interp, cmd) != TCL_OK) {
        Tcl_BackgroundError (_interp);
    }
}

void tcl3dOsgCameraPreCallback::setDrawCallback (const std::string& tclProc)
{
#ifdef DEBUG
    printf ("tcl3dOsgCameraPreCallback::setDrawCallback (tclProc=%s)\n",
            tclProc.c_str()); fflush (stdout);
#endif
    _tclProc = tclProc;
}

const std::string& tcl3dOsgCameraPreCallback::getDrawCallback ()
{
    return _tclProc;
}

tcl3dOsgCameraPostCallback::tcl3dOsgCameraPostCallback (Tcl_Interp *interp, 
                                                        const osg::Camera *cam):
    osg::Camera::DrawCallback (),
    _cam (cam),
    _interp (interp)
{
#ifdef DEBUG
    printf ("tcl3dOsgCameraPostCallback ()\n"); fflush (stdout);
#endif
}

void tcl3dOsgCameraPostCallback::operator () (const osg::Camera& cam) const
{
    char cmd[256];
    char buf[30];
    char *b = buf;
    const osg::Camera *camPtr = &cam;

    memset (buf, 0, sizeof (buf));

#ifdef DEBUG
    printf ("tcl3dOsgCameraPostCallback::operator ()\n"); fflush (stdout);
#endif

    /* OPA TODO
     * This way of creating a SWIG compatible pointer is a hack and should
     * be improved.
     */
    b = SWIG_PackData (b, &camPtr, sizeof (void *));
    sprintf (cmd, "%.*s _%s_p_%s__%s",
             200, _tclProc.c_str(), buf, cam.libraryName(), cam.className());
    if (Tcl_Eval (_interp, cmd) != TCL_OK) {
        Tcl_BackgroundError (_interp);
    }
}

void tcl3dOsgCameraPostCallback::setDrawCallback (const std::string& tclProc)
{
#ifdef DEBUG
    printf ("tcl3dOsgCameraPostCallback::setDrawCallback (tclProc=%s)\n",
            tclProc.c_str()); fflush (stdout);
#endif
    _tclProc = tclProc;
}

const std::string& tcl3dOsgCameraPostCallback::getDrawCallback ()
{
    return _tclProc;
}
%}
