/******************************************************************************
 *{@C
 *      Copyright:      2009-2010 Paul Obermeier (obermeier@tcl3d.org)
 *
 *                      See the file "Tcl3D_License.txt" for information on
 *                      usage and redistribution of this file, and for a
 *                      DISCLAIMER OF ALL WARRANTIES.
 *
 *      Module:         Tcl3D -> tcl3dOsg
 *      Filename:       tcl3dOsgParticle.i
 *
 *      Author:         Paul Obermeier
 *
 *      Description:    SWIG file for wrapping the Open Scene Graph library.
 *                      This file is responsible for package tcl3dOsgParticle.
 *
 *                      The macro USE_OSG_IF must be defined at compilation
 *                      time to include the functionality of the OSG library
 *                      into the Tcl3D package.
 *
 *****************************************************************************/

// The name of our generated Tcl package.

%module tcl3dOsgParticle


// Code to initialize the Tk stubs library.

%{
#include <tk.h>
%}

%init %{
#ifndef USE_OSG_IF
    Tcl_SetResult(interp, (char *) "OSG library not wrapped", TCL_STATIC);
    return TCL_ERROR;
#endif

#ifdef USE_TK_STUBS
    if (Tk_InitStubs(interp, (char*)"8.4", 0) == NULL) {
      return TCL_ERROR;
    }
#endif
%}

#ifdef USE_OSG_IF

// Standard modules from the SWIG library

%include typemaps.i


// Wrap the OSG Particle library.
// The commands of this library will live in the namespace osgParticle.

%include osgParticle.i

#endif
