# OSG MixinVector specific test procedures.
# These procedures are independent of the supplied vector class type.

package require tcl3d

source testUtil.tcl

# Start of test cases.

P "\n>>> Test cases for osg::MixinVector classes <<<\n"

# Test the different constructors.
set mixVec1 [osg::MixinVec3f]
PN "Cnstr ()" ; tcl3dOsgVecArrayPrint $mixVec1

set mixVec2 [osg::MixinVec3f 40]
PN "Cnstr (40)" ; tcl3dOsgVecArrayPrint $mixVec2

set mixVec3 [osg::MixinVec3f 2 [CreateUnitVec osg::Vec3f 3 0]]
PN "Cnstr (size, Vec3f)" ; tcl3dOsgVecArrayPrint $mixVec3 

set mixVec4 [osg::MixinVec3f $mixVec3]
PN "Cnstr (MixinVec)" ; tcl3dOsgVecArrayPrint $mixVec4

$mixVec1 push [osg::Vec3f a 1 2 3]
$mixVec1 push [osg::Vec3f a 4 5 6] 
PN "Pushing 2 Vec3f:" ; tcl3dOsgVecArrayPrint $mixVec1
PN "Is MixinVec empty? :" ; P [$mixVec1 empty]

set last [expr [$mixVec1 size] -1]
set vec1 [$mixVec1 get $last]
set vec2 [$mixVec1 pop]
PN "Vec3f at position $last:" ; tcl3dOsgVecPrint $vec1
PN "Vec3f popped:" ; tcl3dOsgVecPrint $vec2

set last [expr [$mixVec1 size] -1]
set vec1 [$mixVec1 get $last]
set vec2 [$mixVec1 pop]
PN "Vec3f at position $last:" ; tcl3dOsgVecPrint $vec1
PN "Vec3f popped:" ; tcl3dOsgVecPrint $vec2

PN "Is MixinVec empty? :" ; P [$mixVec1 empty]

$mixVec1 push [osg::Vec3f a 10 20 30] 
$mixVec1 push [osg::Vec3f a 11 21 31] 
PN "New MixinVec:" ; tcl3dOsgVecArrayPrint $mixVec1
$mixVec1 set 0 [osg::Vec3f a 5 6 7]
PN "set index 0:" ; tcl3dOsgVecArrayPrint $mixVec1

$mixVec1 clear
PN "MixinVec after clear:" ; P "Is Empty? [$mixVec1 empty] Size: [$mixVec1 size]"

exit
