/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.truth.Fact;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IgnoreJRERequirement;
import com.google.common.truth.Subject;
import java.util.OptionalInt;
import org.checkerframework.checker.nullness.qual.Nullable;

@IgnoreJRERequirement
public final class OptionalIntSubject
extends Subject {
    private final OptionalInt actual;

    OptionalIntSubject(FailureMetadata failureMetadata, @Nullable OptionalInt subject, @Nullable String typeDescription) {
        super(failureMetadata, subject, typeDescription);
        this.actual = subject;
    }

    public void isPresent() {
        if (this.actual == null) {
            this.failWithActual(Fact.simpleFact("expected present optional"), new Fact[0]);
        } else if (!this.actual.isPresent()) {
            this.failWithoutActual(Fact.simpleFact("expected to be present"), new Fact[0]);
        }
    }

    public void isEmpty() {
        if (this.actual == null) {
            this.failWithActual(Fact.simpleFact("expected empty optional"), new Fact[0]);
        } else if (this.actual.isPresent()) {
            this.failWithoutActual(Fact.simpleFact("expected to be empty"), Fact.fact("but was present with value", this.actual.getAsInt()));
        }
    }

    public void hasValue(int expected) {
        if (this.actual == null) {
            this.failWithActual("expected an optional with value", expected);
        } else if (!this.actual.isPresent()) {
            this.failWithoutActual(Fact.fact("expected to have value", expected), Fact.simpleFact("but was absent"));
        } else {
            this.checkNoNeedToDisplayBothValues("getAsInt()", new Object[0]).that(this.actual.getAsInt()).isEqualTo(expected);
        }
    }

    public static Subject.Factory<OptionalIntSubject, OptionalInt> optionalInts() {
        return (metadata, subject) -> new OptionalIntSubject(metadata, (OptionalInt)subject, "optionalInt");
    }
}

