/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.tool.commands.projects;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.rundeck.client.api.model.ProjectConfig;
import org.rundeck.client.tool.InputError;
import org.rundeck.client.tool.ProjectInput;
import org.rundeck.client.tool.extension.BaseCommand;
import org.rundeck.client.tool.options.OptionUtil;
import org.rundeck.client.tool.options.ProjectNameOptions;
import org.rundeck.client.tool.options.ProjectRequiredNameOptions;
import org.rundeck.client.tool.options.UnparsedConfigOptions;
import org.yaml.snakeyaml.LoaderOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import picocli.CommandLine;

@CommandLine.Command(description={"Manage Project configuration"}, name="configure")
public class Configure
extends BaseCommand {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    String validate(ProjectInput opts) throws InputError {
        if (null != opts.getProject()) {
            ProjectRequiredNameOptions.validateProjectName(opts.getProject(), this.spec);
        }
        return this.getRdTool().projectOrEnv(opts);
    }

    @CommandLine.Command(description={"Get all configuration properties for a project. (Supports RD_FORMAT=properties env var)"})
    public void get(@CommandLine.Mixin ProjectNameOptions opts) throws IOException, InputError {
        String project = this.validate(opts);
        ProjectConfig config = (ProjectConfig)this.apiCall(api -> api.getProjectConfiguration(project));
        if ("properties".equals(this.getRdTool().getAppConfig().getString("RD_FORMAT", null))) {
            Properties properties = new Properties();
            properties.putAll(config.getConfig());
            properties.store(System.out, "rd");
        } else {
            this.getRdOutput().output(config.getConfig());
        }
    }

    @CommandLine.Command(description={"Overwrite all configuration properties for a project. Any config keys not included will be removed."}, showEndOfOptionsDelimiterInUsageHelp=true)
    public void set(@CommandLine.Mixin ConfigFileOptions configFileOptions, @CommandLine.Mixin UnparsedConfigOptions unparsedConfigOptions, @CommandLine.Mixin ProjectNameOptions opts) throws IOException, InputError {
        String project = this.validate(opts);
        Map<String, String> config = Configure.loadConfig(configFileOptions, unparsedConfigOptions, true);
        this.apiCall(api -> api.setProjectConfiguration(project, new ProjectConfig(config)));
    }

    public static Map<String, String> loadConfig(ConfigFileOptions opts, UnparsedConfigOptions unparsedConfigOptions, boolean requireInput) throws InputError, IOException {
        HashMap<String, String> inputConfig = new HashMap<String, String>();
        if (opts.getFile() != null) {
            File input = opts.getFile();
            InputFileFormat format = opts.getFileFormat();
            if (null == format) {
                format = InputFileFormat.properties;
                if (input.getName().endsWith(".json")) {
                    format = InputFileFormat.json;
                } else if (input.getName().endsWith(".yaml") || input.getName().endsWith(".yml")) {
                    format = InputFileFormat.yaml;
                }
            }
            switch (format) {
                case properties: {
                    try (FileInputStream fis = new FileInputStream(input);){
                        Properties properties = new Properties();
                        properties.load(fis);
                        for (Object key : properties.keySet()) {
                            inputConfig.put(key.toString(), properties.getProperty(key.toString()));
                        }
                        break;
                    }
                }
                case json: {
                    ObjectMapper objectMapper = new ObjectMapper();
                    Map map = objectMapper.readValue(input, Map.class);
                    for (Object o : map.keySet()) {
                        if (!(o instanceof String)) {
                            throw new InputError(String.format("Expected all keys of the json object to be strings, but saw: %s for: %s", o.getClass(), o));
                        }
                        Object value = map.get(o);
                        if (value instanceof String) continue;
                        throw new InputError(String.format("Expected all values of the json object to be strings, but saw: %s for: %s, for key: %s", value.getClass(), value, o));
                    }
                    inputConfig.putAll(map);
                    break;
                }
                case yaml: {
                    Yaml yaml = new Yaml(new SafeConstructor(new LoaderOptions()));
                    try (FileInputStream fis = new FileInputStream(input);){
                        Object load = yaml.load(fis);
                        if (load instanceof Map) {
                            inputConfig.putAll((Map)load);
                            break;
                        }
                        throw new InputError("Yaml.load: data is not a Map");
                    }
                }
            }
        }
        if (unparsedConfigOptions.getConfig() != null && unparsedConfigOptions.getConfig().size() > 0) {
            Map<String, String> config = OptionUtil.parseKeyValueMap(unparsedConfigOptions.getConfig());
            inputConfig.putAll(config);
        }
        if (inputConfig.size() < 1 && requireInput) {
            throw new InputError("no configuration was specified");
        }
        return inputConfig;
    }

    @CommandLine.Command(description={"Modify configuration properties for a project. Only the specified keys will be updated. Can provide input via a file (json, properties or yaml), or commandline. If both are provided, the commandline values will override the loaded file values."}, showEndOfOptionsDelimiterInUsageHelp=true)
    public void update(@CommandLine.Mixin ConfigFileOptions configFileOptions, @CommandLine.Mixin UnparsedConfigOptions unparsedConfigOptions, @CommandLine.Mixin ProjectNameOptions opts) throws IOException, InputError {
        String project = this.validate(opts);
        Map<String, String> config = Configure.loadConfig(configFileOptions, unparsedConfigOptions, true);
        this.getRdOutput().info(String.format("Updating %d configuration properties...", config.size()));
        for (String s : config.keySet()) {
            ProjectConfig body = new ProjectConfig(Collections.singletonMap("value", config.get(s)));
            ProjectConfig result = (ProjectConfig)this.apiCall(api -> api.setProjectConfigurationKey(project, s, body));
            this.getRdOutput().info("Updated value: " + result.getConfig());
        }
    }

    @CommandLine.Command(description={"Remove configuration properties for a project."}, showEndOfOptionsDelimiterInUsageHelp=true)
    public void delete(@CommandLine.Mixin ConfigureDeleteOpts opts) throws IOException, InputError {
        String project = this.validate(opts);
        List<String> removeKeys = opts.getConfig();
        if (removeKeys.size() < 1) {
            throw new InputError("use `-- key1 key2` to specify keys to delete");
        }
        this.getRdOutput().info(String.format("Removing %d configuration properties...", removeKeys.size()));
        for (String s : removeKeys) {
            Void result = (Void)this.apiCall(api -> api.deleteProjectConfigurationKey(project, s));
            this.getRdOutput().info("Removed key: " + s);
        }
    }

    static class ConfigureDeleteOpts
    extends ProjectNameOptions {
        @CommandLine.Parameters(paramLabel="key [key [key..]]", description={"A list of config keys to remove, space separated after a '--' separator. "})
        List<String> config;

        ConfigureDeleteOpts() {
        }

        public List<String> getConfig() {
            return this.config;
        }

        public void setConfig(List<String> config) {
            this.config = config;
        }
    }

    public static class ConfigFileOptions {
        @CommandLine.Option(names={"-f", "--file"}, description={"Input file for project configuration. Can be a .properties, .json or .yaml file. Format is determined by file extension or -F/--format"})
        File file;
        @CommandLine.Option(names={"-F", "--format"}, description={"Input file format. Can be [properties, json, yaml] (default: properties, unless recognized in filename)"})
        InputFileFormat fileFormat;

        public File getFile() {
            return this.file;
        }

        public InputFileFormat getFileFormat() {
            return this.fileFormat;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public void setFileFormat(InputFileFormat fileFormat) {
            this.fileFormat = fileFormat;
        }
    }

    public static enum InputFileFormat {
        properties,
        json,
        yaml;

    }
}

