/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import proguard.Configuration;
import proguard.DescriptorKeepChecker;
import proguard.FullyQualifiedClassNameChecker;
import proguard.KeepClassSpecification;
import proguard.MemberSpecification;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.constant.visitor.AllConstantVisitor;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.util.ClassReferenceInitializer;
import proguard.classfile.util.ClassSubHierarchyInitializer;
import proguard.classfile.util.ClassSuperHierarchyInitializer;
import proguard.classfile.util.DynamicClassReferenceInitializer;
import proguard.classfile.util.DynamicMemberReferenceInitializer;
import proguard.classfile.util.StringReferenceInitializer;
import proguard.classfile.util.StringSharer;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.ClassHierarchyTraveler;
import proguard.classfile.visitor.ClassNameFilter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.LibraryClassFilter;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.util.ClassNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;

public class Initializer {
    private final Configuration configuration;

    public Initializer(Configuration configuration) {
        this.configuration = configuration;
    }

    public void execute(ClassPool classPool, ClassPool classPool2) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        int n8 = classPool2.size();
        ClassPool classPool3 = this.configuration.useUniqueClassMemberNames ? null : new ClassPool();
        WarningPrinter warningPrinter = new WarningPrinter(System.err, this.configuration.warn);
        WarningPrinter warningPrinter2 = new WarningPrinter(System.err, this.configuration.warn);
        classPool.classesAccept(new ClassSuperHierarchyInitializer(classPool, classPool2, warningPrinter, null));
        classPool2.classesAccept(new ClassSuperHierarchyInitializer(classPool, classPool2, null, warningPrinter2));
        WarningPrinter warningPrinter3 = new WarningPrinter(System.err, this.configuration.warn);
        classPool.classesAccept(new ClassReferenceInitializer(classPool, classPool2, warningPrinter, warningPrinter3, null));
        if (classPool3 != null) {
            classPool.classesAccept(new ReferencedClassVisitor(new LibraryClassFilter(new ClassPoolFiller(classPool3))));
            classPool3.classesAccept(new ClassSuperHierarchyInitializer(classPool, classPool2, warningPrinter, null));
        }
        WarningPrinter warningPrinter4 = new WarningPrinter(System.out, this.configuration.note);
        WarningPrinter warningPrinter5 = new WarningPrinter(System.out, this.configuration.note);
        classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new DynamicClassReferenceInitializer(classPool, classPool2, warningPrinter4, null, warningPrinter5, this.createClassNoteExceptionMatcher(this.configuration.keep))))));
        WarningPrinter warningPrinter6 = new WarningPrinter(System.out, this.configuration.note);
        classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new DynamicMemberReferenceInitializer(classPool, classPool2, warningPrinter6, this.createClassMemberNoteExceptionMatcher(this.configuration.keep, true), this.createClassMemberNoteExceptionMatcher(this.configuration.keep, false))))));
        if (this.configuration.adaptClassStrings != null) {
            classPool.classesAccept(new ClassNameFilter(this.configuration.adaptClassStrings, (ClassVisitor)new AllConstantVisitor(new StringReferenceInitializer(classPool, classPool2))));
        }
        WarningPrinter warningPrinter7 = new WarningPrinter(System.out, this.configuration.note);
        WarningPrinter warningPrinter8 = new WarningPrinter(System.out, this.configuration.note);
        new FullyQualifiedClassNameChecker(classPool, classPool2, warningPrinter7).checkClassSpecifications(this.configuration.keep);
        new DescriptorKeepChecker(classPool, classPool2, warningPrinter8).checkClassSpecifications(this.configuration.keep);
        if (classPool3 != null) {
            classPool.classesAccept(new ReferencedClassVisitor(new LibraryClassFilter(new ClassHierarchyTraveler(true, true, true, false, new LibraryClassFilter(new ClassPoolFiller(classPool3))))));
            classPool3.classesAccept(new ClassReferenceInitializer(classPool, classPool2, null, null, warningPrinter2));
            classPool2.clear();
            classPool3.classesAccept(new MultiClassVisitor(new ClassVisitor[]{new ClassHierarchyTraveler(true, true, true, false, new LibraryClassFilter(new ClassPoolFiller(classPool2))), new ReferencedClassVisitor(new LibraryClassFilter(new ClassHierarchyTraveler(true, true, true, false, new LibraryClassFilter(new ClassPoolFiller(classPool2)))))}));
        } else {
            classPool2.classesAccept(new ClassReferenceInitializer(classPool, classPool2, null, null, warningPrinter2));
        }
        classPool.classesAccept(new ClassSubHierarchyInitializer());
        classPool2.classesAccept(new ClassSubHierarchyInitializer());
        classPool.classesAccept(new StringSharer());
        classPool2.classesAccept(new StringSharer());
        int n9 = warningPrinter7.getWarningCount();
        if (n9 > 0) {
            System.out.println("Note: there were " + n9 + " references to unknown classes.");
            System.out.println("      You should check your configuration for typos.");
        }
        if ((n7 = warningPrinter8.getWarningCount()) > 0) {
            System.out.println("Note: there were " + n7 + " unkept descriptor classes in kept class members.");
            System.out.println("      You should consider explicitly keeping the mentioned classes");
            System.out.println("      (using '-keep').");
        }
        if ((n6 = warningPrinter4.getWarningCount()) > 0) {
            System.out.println("Note: there were " + n6 + " unresolved dynamic references to classes or interfaces.");
            System.err.println("      You should check if you need to specify additional program jars.");
        }
        if ((n5 = warningPrinter5.getWarningCount()) > 0) {
            System.out.println("Note: there were " + n5 + " class casts of dynamically created class instances.");
            System.out.println("      You might consider explicitly keeping the mentioned classes and/or");
            System.out.println("      their implementations (using '-keep').");
        }
        if ((n4 = warningPrinter6.getWarningCount()) > 0) {
            System.out.println("Note: there were " + n4 + " accesses to class members by means of introspection.");
            System.out.println("      You should consider explicitly keeping the mentioned class members");
            System.out.println("      (using '-keep' or '-keepclassmembers').");
        }
        if ((n3 = warningPrinter.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + n3 + " unresolved references to classes or interfaces.");
            System.err.println("         You may need to specify additional library jars (using '-libraryjars').");
            if (this.configuration.skipNonPublicLibraryClasses) {
                System.err.println("         You may also have to remove the option '-skipnonpubliclibraryclasses'.");
            }
        }
        if ((n2 = warningPrinter2.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + n2 + " instances of library classes depending on program classes.");
            System.err.println("         You must avoid such dependencies, since the program classes will");
            System.err.println("         be processed, while the library classes will remain unchanged.");
        }
        if ((n = warningPrinter3.getWarningCount()) > 0) {
            System.err.println("Warning: there were " + n + " unresolved references to program class members.");
            System.err.println("         Your input classes appear to be inconsistent.");
            System.err.println("         You may need to recompile them and try again.");
            System.err.println("         Alternatively, you may have to specify the option ");
            System.err.println("         '-dontskipnonpubliclibraryclassmembers'.");
            if (this.configuration.skipNonPublicLibraryClasses) {
                System.err.println("         You may also have to remove the option '-skipnonpubliclibraryclasses'.");
            }
        }
        if (!(n3 <= 0 && n2 <= 0 && n <= 0 || this.configuration.ignoreWarnings)) {
            throw new IOException("Please correct the above warnings first.");
        }
        if ((this.configuration.note == null || !this.configuration.note.isEmpty()) && (this.configuration.warn != null && this.configuration.warn.isEmpty() || this.configuration.ignoreWarnings)) {
            System.out.println("Note: You're ignoring all warnings!");
        }
        if (this.configuration.verbose) {
            System.out.println("Ignoring unused library classes...");
            System.out.println("  Original number of library classes: " + n8);
            System.out.println("  Final number of library classes:    " + classPool2.size());
        }
    }

    private StringMatcher createClassNoteExceptionMatcher(List list) {
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>(list.size());
            for (int i = 0; i < list.size(); ++i) {
                String string;
                KeepClassSpecification keepClassSpecification = (KeepClassSpecification)list.get(i);
                if (!keepClassSpecification.markClasses) continue;
                String string2 = keepClassSpecification.className;
                if (string2 != null) {
                    arrayList.add(string2);
                }
                if ((string = keepClassSpecification.extendsClassName) == null) continue;
                arrayList.add(string);
            }
            if (arrayList.size() > 0) {
                return new ListParser(new ClassNameParser()).parse(arrayList);
            }
        }
        return null;
    }

    private StringMatcher createClassMemberNoteExceptionMatcher(List list, boolean bl) {
        if (list != null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < list.size(); ++i) {
                List list2;
                KeepClassSpecification keepClassSpecification = (KeepClassSpecification)list.get(i);
                List list3 = list2 = bl ? keepClassSpecification.fieldSpecifications : keepClassSpecification.methodSpecifications;
                if (list2 == null) continue;
                for (int j = 0; j < list2.size(); ++j) {
                    MemberSpecification memberSpecification = (MemberSpecification)list2.get(j);
                    String string = memberSpecification.name;
                    if (string == null) continue;
                    arrayList.add(string);
                }
            }
            if (arrayList.size() > 0) {
                return new ListParser(new ClassNameParser()).parse(arrayList);
            }
        }
        return null;
    }
}

