/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.comparator;

import com.jidesoft.comparator.ComparatorContext;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlphanumComparator
implements Comparator<CharSequence> {
    private boolean _caseSensitive;
    public static final ComparatorContext CONTEXT = new ComparatorContext("Alphanum");
    public static final ComparatorContext CONTEXT_IGNORE_CASE = new ComparatorContext("Alphanum_Ignorecase");

    public AlphanumComparator() {
        this(true);
    }

    public AlphanumComparator(boolean bl) {
        this._caseSensitive = bl;
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private String getChunk(CharSequence charSequence, int n, int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        char c = charSequence.charAt(n2);
        stringBuilder.append(c);
        ++n2;
        if (this.isDigit(c)) {
            while (n2 < n && this.isDigit(c = charSequence.charAt(n2))) {
                stringBuilder.append(c);
                ++n2;
            }
        } else {
            while (n2 < n && !this.isDigit(c = charSequence.charAt(n2))) {
                stringBuilder.append(c);
                ++n2;
            }
        }
        return stringBuilder.toString();
    }

    @Override
    public int compare(CharSequence charSequence, CharSequence charSequence2) {
        int n = 0;
        int n2 = 0;
        int n3 = charSequence.length();
        int n4 = charSequence2.length();
        while (n < n3 && n2 < n4) {
            int n5;
            String string = this.getChunk(charSequence, n3, n);
            n += string.length();
            String string2 = this.getChunk(charSequence2, n4, n2);
            n2 += string2.length();
            if (this.isDigit(string.charAt(0)) && this.isDigit(string2.charAt(0))) {
                int n6 = string.length();
                n5 = n6 - string2.length();
                if (n5 == 0) {
                    for (int i = 0; i < n6; ++i) {
                        n5 = string.charAt(i) - string2.charAt(i);
                        if (n5 == 0) continue;
                        return n5;
                    }
                }
            } else {
                int n7 = n5 = this.isCaseSensitive() ? string.compareTo(string2) : string.compareToIgnoreCase(string2);
            }
            if (n5 == 0) continue;
            return n5;
        }
        return n3 - n4;
    }

    public boolean isCaseSensitive() {
        return this._caseSensitive;
    }

    public void setCaseSensitive(boolean bl) {
        this._caseSensitive = bl;
    }
}

