/*
 * Decompiled with CFR 0.152.
 */
package com.tivo.jipviewer;

import com.tivo.jipviewer.JipMethod;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JipFrame {
    private JipFrame mParent;
    private final JipMethod mMethod;
    private final long mThreadId;
    private final long mCount;
    private long mTotalTime;
    private long mNetTime;
    private List<JipFrame> mvChildren = new ArrayList<JipFrame>();

    JipFrame(JipFrame jipFrame, JipMethod jipMethod, long l, long l2, long l3) {
        this.mParent = jipFrame;
        this.mMethod = jipMethod;
        this.mThreadId = l;
        this.mCount = l2;
        this.mTotalTime = l3;
        if (this.mParent != null) {
            this.mParent.mvChildren.add(this);
        }
    }

    JipMethod getMethod() {
        return this.mMethod;
    }

    long getCount() {
        return this.mCount;
    }

    long getTotalTime() {
        return this.mTotalTime;
    }

    long getNetTime() {
        return this.mNetTime;
    }

    JipFrame getParentOrNull() {
        return this.mParent;
    }

    List<JipFrame> getChildren() {
        return this.mvChildren;
    }

    boolean isReentrant() {
        for (JipFrame jipFrame = this.mParent; jipFrame != null; jipFrame = jipFrame.getParentOrNull()) {
            if (!jipFrame.getMethod().equals(this.mMethod)) continue;
            return true;
        }
        return false;
    }

    void computeNetTime() {
        long l = 0L;
        for (JipFrame jipFrame : this.mvChildren) {
            l += jipFrame.getTotalTime();
        }
        this.mNetTime = this.mTotalTime - l;
        if (this.mNetTime < 0L) {
            this.mNetTime = 0L;
        }
    }
}

