/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.basic.BasicArrowButton;
import org.openstreetmap.josm.actions.ExpertToggleAction;
import org.openstreetmap.josm.actions.mapmode.DeleteAction;
import org.openstreetmap.josm.actions.mapmode.DrawAction;
import org.openstreetmap.josm.actions.mapmode.ExtrudeAction;
import org.openstreetmap.josm.actions.mapmode.ImproveWayAccuracyAction;
import org.openstreetmap.josm.actions.mapmode.MapMode;
import org.openstreetmap.josm.actions.mapmode.ParallelWayAction;
import org.openstreetmap.josm.actions.mapmode.SelectAction;
import org.openstreetmap.josm.actions.mapmode.SelectLassoAction;
import org.openstreetmap.josm.actions.mapmode.SplitMode;
import org.openstreetmap.josm.actions.mapmode.ZoomAction;
import org.openstreetmap.josm.data.ViewportData;
import org.openstreetmap.josm.data.preferences.AbstractProperty;
import org.openstreetmap.josm.data.preferences.BooleanProperty;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.HideableButton;
import org.openstreetmap.josm.gui.IconToggleButton;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.MapStatus;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.ScrollViewport;
import org.openstreetmap.josm.gui.dialogs.ChangesetDialog;
import org.openstreetmap.josm.gui.dialogs.CommandStackDialog;
import org.openstreetmap.josm.gui.dialogs.ConflictDialog;
import org.openstreetmap.josm.gui.dialogs.DialogsPanel;
import org.openstreetmap.josm.gui.dialogs.FilterDialog;
import org.openstreetmap.josm.gui.dialogs.LayerListDialog;
import org.openstreetmap.josm.gui.dialogs.MapPaintDialog;
import org.openstreetmap.josm.gui.dialogs.MinimapDialog;
import org.openstreetmap.josm.gui.dialogs.NotesDialog;
import org.openstreetmap.josm.gui.dialogs.RelationListDialog;
import org.openstreetmap.josm.gui.dialogs.SelectionListDialog;
import org.openstreetmap.josm.gui.dialogs.ToggleDialog;
import org.openstreetmap.josm.gui.dialogs.UserListDialog;
import org.openstreetmap.josm.gui.dialogs.ValidatorDialog;
import org.openstreetmap.josm.gui.dialogs.properties.PropertiesDialog;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.LayerManager;
import org.openstreetmap.josm.gui.layer.MainLayerManager;
import org.openstreetmap.josm.gui.util.AdvancedKeyPressDetector;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;

public class MapFrame
extends JPanel
implements Destroyable,
MainLayerManager.ActiveLayerChangeListener,
LayerManager.LayerChangeListener {
    public static final int DEF_TOGGLE_DLG_WIDTH = 330;
    private static final IntegerProperty TOGGLE_DIALOGS_WIDTH = new IntegerProperty("toggleDialogs.width", 330);
    public static final BooleanProperty MODELESS = new BooleanProperty("modeless", false);
    public static final BooleanProperty TOOLBAR_VISIBLE = new BooleanProperty("toolbar.visible", true);
    public static final BooleanProperty SIDE_TOOLBAR_VISIBLE = new BooleanProperty("sidetoolbar.visible", true);
    public MapMode mapMode;
    public final MapView mapView;
    public final transient AdvancedKeyPressDetector keyDetector = new AdvancedKeyPressDetector();
    private JComponent sideToolBar = new JToolBar(1);
    private final ButtonGroup toolBarActionsGroup = new ButtonGroup();
    private final JToolBar toolBarActions = new JToolBar(1);
    private final JToolBar toolBarToggle = new JToolBar(1);
    private final List<ToggleDialog> allDialogs = new ArrayList<ToggleDialog>();
    private final List<IconToggleButton> allDialogButtons = new ArrayList<IconToggleButton>();
    public final List<IconToggleButton> allMapModeButtons = new ArrayList<IconToggleButton>();
    private final ListAllButtonsAction listAllDialogsAction = new ListAllButtonsAction(this.allDialogButtons);
    private final ListAllButtonsAction listAllMapModesAction = new ListAllButtonsAction(this.allMapModeButtons);
    public final ConflictDialog conflictDialog;
    public final FilterDialog filterDialog;
    public final RelationListDialog relationListDialog;
    public final ValidatorDialog validatorDialog;
    public final SelectionListDialog selectionListDialog;
    public final PropertiesDialog propertiesDialog;
    public final MapPaintDialog mapPaintDialog;
    public final NotesDialog noteDialog;
    public final SelectAction mapModeSelect;
    public final DrawAction mapModeDraw;
    public final ZoomAction mapModeZoom;
    public final DeleteAction mapModeDelete;
    public final SelectLassoAction mapModeSelectLasso;
    private final transient Map<Layer, MapMode> lastMapMode = new HashMap<Layer, MapMode>();
    public MapStatus statusLine;
    private final JSplitPane splitPane;
    private final JPanel leftPanel;
    private final DialogsPanel dialogsPanel;
    private static final CopyOnWriteArrayList<MapModeChangeListener> mapModeChangeListeners = new CopyOnWriteArrayList();
    private transient AbstractProperty.ValueChangeListener<Boolean> sidetoolbarPreferencesChangedListener;

    public MapFrame(ViewportData viewportData) {
        this.setSize(400, 400);
        this.setLayout(new BorderLayout());
        this.mapView = new MapView(MainApplication.getLayerManager(), viewportData);
        this.splitPane = new JSplitPane(1, true);
        this.leftPanel = new JPanel(new GridBagLayout());
        this.leftPanel.add((Component)this.mapView, GBC.std().fill());
        this.splitPane.setLeftComponent(this.leftPanel);
        this.dialogsPanel = new DialogsPanel(this.splitPane);
        this.splitPane.setRightComponent(this.dialogsPanel);
        this.splitPane.setResizeWeight(1.0);
        this.splitPane.setDividerSize(5);
        this.splitPane.setBorder(null);
        InputMap splitInputMap = this.splitPane.getInputMap(1);
        splitInputMap.put(KeyStroke.getKeyStroke(117, 0), new Object());
        splitInputMap.put(KeyStroke.getKeyStroke(119, 0), new Object());
        splitInputMap.put(KeyStroke.getKeyStroke(36, 0), new Object());
        splitInputMap.put(KeyStroke.getKeyStroke(35, 0), new Object());
        this.add((Component)this.splitPane, "Center");
        this.dialogsPanel.setLayout(new BoxLayout(this.dialogsPanel, 1));
        this.dialogsPanel.setPreferredSize(new Dimension(TOGGLE_DIALOGS_WIDTH.get(), 0));
        this.dialogsPanel.setMinimumSize(new Dimension(24, 0));
        this.mapView.setMinimumSize(new Dimension(10, 0));
        this.mapModeSelect = new SelectAction(this);
        this.mapModeSelectLasso = new SelectLassoAction();
        this.mapModeDraw = new DrawAction();
        this.mapModeZoom = new ZoomAction(this);
        this.mapModeDelete = new DeleteAction();
        this.addMapMode(new IconToggleButton(this.mapModeSelect, false));
        this.addMapMode(new IconToggleButton(this.mapModeSelectLasso, true));
        this.addMapMode(new IconToggleButton(this.mapModeDraw, false));
        this.addMapMode(new IconToggleButton(this.mapModeZoom, true));
        this.addMapMode(new IconToggleButton(this.mapModeDelete, true));
        this.addMapMode(new IconToggleButton(new ParallelWayAction(this), true));
        this.addMapMode(new IconToggleButton(new ExtrudeAction(), true));
        this.addMapMode(new IconToggleButton(new ImproveWayAccuracyAction(), false));
        this.addMapMode(new IconToggleButton(new SplitMode(), false));
        this.toolBarActionsGroup.setSelected(this.allMapModeButtons.get(0).getModel(), true);
        this.toolBarActions.setFloatable(false);
        LayerListDialog.createInstance(this.mapView.getLayerManager());
        this.propertiesDialog = new PropertiesDialog();
        this.selectionListDialog = new SelectionListDialog();
        this.relationListDialog = new RelationListDialog();
        this.conflictDialog = new ConflictDialog();
        this.validatorDialog = new ValidatorDialog();
        this.filterDialog = new FilterDialog();
        this.mapPaintDialog = new MapPaintDialog();
        this.noteDialog = new NotesDialog();
        this.addToggleDialog(LayerListDialog.getInstance());
        this.addToggleDialog(this.propertiesDialog);
        this.addToggleDialog(this.selectionListDialog);
        this.addToggleDialog(this.relationListDialog);
        this.addToggleDialog(new MinimapDialog());
        this.addToggleDialog(new CommandStackDialog());
        this.addToggleDialog(new UserListDialog());
        this.addToggleDialog(this.conflictDialog);
        this.addToggleDialog(this.validatorDialog);
        this.addToggleDialog(this.filterDialog);
        this.addToggleDialog(new ChangesetDialog(), true);
        this.addToggleDialog(this.mapPaintDialog);
        this.addToggleDialog(this.noteDialog);
        this.toolBarToggle.setFloatable(false);
        this.statusLine = new MapStatus(this);
        MainApplication.getLayerManager().addLayerChangeListener(this);
        MainApplication.getLayerManager().addActiveLayerChangeListener(this);
        boolean unregisterTab = Shortcut.findShortcut(9, 0).isPresent();
        if (unregisterTab) {
            for (JComponent jComponent : this.allDialogButtons) {
                jComponent.setFocusTraversalKeysEnabled(false);
            }
            for (JComponent jComponent : this.allMapModeButtons) {
                jComponent.setFocusTraversalKeysEnabled(false);
            }
        }
        if (Config.getPref().getBoolean("debug.advanced-keypress-detector.enable", true)) {
            this.keyDetector.register();
        }
    }

    public boolean selectSelectTool(boolean onlyIfModeless) {
        if (onlyIfModeless && Boolean.FALSE.equals(MODELESS.get())) {
            return false;
        }
        return this.selectMapMode(this.mapModeSelect);
    }

    public boolean selectDrawTool(boolean onlyIfModeless) {
        if (onlyIfModeless && Boolean.FALSE.equals(MODELESS.get())) {
            return false;
        }
        return this.selectMapMode(this.mapModeDraw);
    }

    public boolean selectZoomTool(boolean onlyIfModeless) {
        if (onlyIfModeless && Boolean.FALSE.equals(MODELESS.get())) {
            return false;
        }
        return this.selectMapMode(this.mapModeZoom);
    }

    @Override
    public void destroy() {
        int i;
        MainApplication.getLayerManager().removeLayerChangeListener(this);
        MainApplication.getLayerManager().removeActiveLayerChangeListener(this);
        MainApplication.getMenu().modeMenu.removeAll();
        this.rememberToggleDialogWidth();
        this.dialogsPanel.destroy();
        SIDE_TOOLBAR_VISIBLE.removeListener(this.sidetoolbarPreferencesChangedListener);
        for (i = 0; i < this.toolBarActions.getComponentCount(); ++i) {
            if (!(this.toolBarActions.getComponent(i) instanceof Destroyable)) continue;
            ((Destroyable)((Object)this.toolBarActions.getComponent(i))).destroy();
        }
        this.toolBarActions.removeAll();
        for (i = 0; i < this.toolBarToggle.getComponentCount(); ++i) {
            if (!(this.toolBarToggle.getComponent(i) instanceof Destroyable)) continue;
            ((Destroyable)((Object)this.toolBarToggle.getComponent(i))).destroy();
        }
        this.toolBarToggle.removeAll();
        this.statusLine.destroy();
        this.mapView.destroy();
        this.keyDetector.unregister();
        this.allDialogs.clear();
        this.allDialogButtons.clear();
        this.allMapModeButtons.clear();
    }

    public Action getDefaultButtonAction() {
        return ((AbstractButton)this.toolBarActions.getComponent(0)).getAction();
    }

    public void initializeDialogsPane() {
        this.dialogsPanel.initialize(this.allDialogs);
    }

    public IconToggleButton addToggleDialog(ToggleDialog dlg) {
        return this.addToggleDialog(dlg, false);
    }

    public IconToggleButton addToggleDialog(ToggleDialog dlg, boolean isExpert) {
        IconToggleButton button = new IconToggleButton(dlg.getToggleAction(), isExpert);
        button.setShowHideButtonListener(dlg);
        button.setInheritsPopupMenu(true);
        dlg.setButton(button);
        this.toolBarToggle.add(button);
        this.allDialogs.add(dlg);
        this.allDialogButtons.add(button);
        button.applyButtonHiddenPreferences();
        if (this.dialogsPanel.initialized) {
            this.dialogsPanel.add(dlg);
        }
        return button;
    }

    public void removeToggleDialog(ToggleDialog dlg) {
        JToggleButton button = dlg.getButton();
        if (button != null) {
            this.allDialogButtons.remove(button);
            this.toolBarToggle.remove(button);
        }
        this.dialogsPanel.remove(dlg);
        this.allDialogs.remove(dlg);
    }

    public void addMapMode(IconToggleButton b) {
        if (!(b.getAction() instanceof MapMode)) {
            throw new IllegalArgumentException("MapMode action must be subclass of MapMode");
        }
        MainMenu.add(MainApplication.getMenu().modeMenu, (MapMode)b.getAction());
        this.allMapModeButtons.add(b);
        this.toolBarActionsGroup.add(b);
        this.toolBarActions.add(b);
        b.applyButtonHiddenPreferences();
        b.setInheritsPopupMenu(true);
    }

    @Override
    public void setVisible(boolean aFlag) {
        boolean old = this.isVisible();
        super.setVisible(aFlag);
        if (old != aFlag) {
            this.firePropertyChange("visible", old, aFlag);
        }
    }

    public boolean selectMapMode(MapMode newMapMode) {
        return this.selectMapMode(newMapMode, this.mapView.getLayerManager().getActiveLayer());
    }

    public boolean selectMapMode(MapMode newMapMode, Layer newLayer) {
        MapMode oldMapMode = this.mapMode;
        if (newMapMode == oldMapMode) {
            return true;
        }
        if (newMapMode == null || !newMapMode.layerIsSupported(newLayer)) {
            newMapMode = null;
        }
        Logging.debug("Switching map mode from {0} to {1}", Optional.ofNullable(oldMapMode).map(m -> m.getClass().getSimpleName()).orElse("(none)"), Optional.ofNullable(newMapMode).map(m -> m.getClass().getSimpleName()).orElse("(none)"));
        if (oldMapMode != null) {
            MainApplication.getMenu().findMapModeMenuItem(oldMapMode).ifPresent(m -> m.setSelected(false));
            oldMapMode.exitMode();
        }
        this.mapMode = newMapMode;
        if (newMapMode != null) {
            newMapMode.enterMode();
            MainApplication.getMenu().findMapModeMenuItem(newMapMode).ifPresent(m -> m.setSelected(true));
        }
        this.lastMapMode.put(newLayer, newMapMode);
        MapFrame.fireMapModeChanged(oldMapMode, newMapMode);
        return newMapMode != null;
    }

    public void fillPanel(Container panel) {
        panel.add((Component)this, "Center");
        if (Config.getPref().getBoolean("sidetoolbar.mapmodes.visible", true)) {
            this.toolBarActions.setAlignmentX(0.5f);
            this.toolBarActions.setBorder(null);
            this.toolBarActions.setInheritsPopupMenu(true);
            this.sideToolBar.add(this.toolBarActions);
            this.sideToolBar.add(this.listAllMapModesAction.createButton());
        }
        if (Config.getPref().getBoolean("sidetoolbar.toggledialogs.visible", true)) {
            ((JToolBar)this.sideToolBar).addSeparator(new Dimension(0, 18));
            this.toolBarToggle.setAlignmentX(0.5f);
            this.toolBarToggle.setBorder(null);
            this.toolBarToggle.setInheritsPopupMenu(true);
            this.sideToolBar.add(this.toolBarToggle);
            this.sideToolBar.add(this.listAllDialogsAction.createButton());
        }
        this.sideToolBar.setComponentPopupMenu(new SideToolbarPopupMenu());
        ((JToolBar)this.sideToolBar).setFloatable(false);
        this.sideToolBar.setBorder(BorderFactory.createEmptyBorder(0, 1, 0, 1));
        if (Config.getPref().getBoolean("sidetoolbar.scrollable", true)) {
            this.sideToolBar = new ScrollViewport(this.sideToolBar, 3);
        }
        this.sideToolBar.setVisible(SIDE_TOOLBAR_VISIBLE.get());
        this.sidetoolbarPreferencesChangedListener = e -> this.sideToolBar.setVisible((Boolean)e.getProperty().get());
        SIDE_TOOLBAR_VISIBLE.addListener(this.sidetoolbarPreferencesChangedListener);
        panel.add((Component)this.sideToolBar, "West");
        if (this.statusLine != null && Config.getPref().getBoolean("statusline.visible", true)) {
            panel.add((Component)this.statusLine, "South");
        }
    }

    public void validateToolBarsVisibility() {
        for (IconToggleButton b : this.allDialogButtons) {
            b.applyButtonHiddenPreferences();
        }
        this.toolBarToggle.repaint();
        for (IconToggleButton b : this.allMapModeButtons) {
            b.applyButtonHiddenPreferences();
        }
        this.toolBarActions.repaint();
    }

    public <T extends ToggleDialog> T getToggleDialog(Class<T> type) {
        return this.dialogsPanel.getToggleDialog(type);
    }

    public void setDialogsPanelVisible(boolean visible) {
        this.rememberToggleDialogWidth();
        this.dialogsPanel.setVisible(visible);
        this.splitPane.setDividerLocation(visible ? this.splitPane.getWidth() - TOGGLE_DIALOGS_WIDTH.get() : 0);
        this.splitPane.setDividerSize(visible ? 5 : 0);
    }

    public void rememberToggleDialogWidth() {
        if (this.dialogsPanel.isVisible()) {
            TOGGLE_DIALOGS_WIDTH.put(this.splitPane.getWidth() - this.splitPane.getDividerLocation() - this.splitPane.getDividerSize() - 1);
        }
    }

    public void removeTopPanel(Class<?> type) {
        int n = this.leftPanel.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = this.leftPanel.getComponent(i);
            if (!type.isInstance(c)) continue;
            this.leftPanel.remove(i);
            this.leftPanel.doLayout();
            return;
        }
    }

    public <T> T getTopPanel(Class<T> type) {
        return Arrays.stream(this.leftPanel.getComponents()).filter(type::isInstance).findFirst().map(type::cast).orElse(null);
    }

    public void addTopPanel(Component c) {
        this.leftPanel.add(c, GBC.eol().fill(2), this.leftPanel.getComponentCount() - 1);
        this.leftPanel.doLayout();
        c.doLayout();
    }

    public static void addMapModeChangeListener(MapModeChangeListener listener) {
        if (listener != null) {
            mapModeChangeListeners.addIfAbsent(listener);
        }
    }

    public static void removeMapModeChangeListener(MapModeChangeListener listener) {
        mapModeChangeListeners.remove(listener);
    }

    protected static void fireMapModeChanged(MapMode oldMapMode, MapMode newMapMode) {
        for (MapModeChangeListener l : mapModeChangeListeners) {
            l.mapModeChange(oldMapMode, newMapMode);
        }
    }

    @Override
    public void activeOrEditLayerChanged(MainLayerManager.ActiveLayerChangeEvent e) {
        boolean modeChanged = false;
        Layer newLayer = e.getSource().getActiveLayer();
        if (this.mapMode == null || !this.mapMode.layerIsSupported(newLayer)) {
            MapMode newMapMode = this.getLastMapMode(newLayer);
            boolean bl = modeChanged = newMapMode != this.mapMode;
            if (newMapMode != null) {
                this.selectMapMode(newMapMode, newLayer);
            } else if (this.mapMode != null) {
                this.mapMode.exitMode();
                this.mapMode = null;
            }
        }
        if (e.getPreviousActiveLayer() != null && !modeChanged && this.mapMode != null) {
            this.mapMode.exitMode();
            this.mapMode.enterMode();
        }
        this.validateToolBarsVisibility();
    }

    private MapMode getLastMapMode(Layer newLayer) {
        Action defaultMode;
        MapMode mode = this.lastMapMode.get(newLayer);
        if (mode == null && (defaultMode = this.getDefaultButtonAction()) instanceof MapMode && ((MapMode)defaultMode).layerIsSupported(newLayer)) {
            mode = (MapMode)defaultMode;
        }
        return mode;
    }

    @Override
    public void layerAdded(LayerManager.LayerAddEvent e) {
    }

    @Override
    public void layerRemoving(LayerManager.LayerRemoveEvent e) {
        this.lastMapMode.remove(e.getRemovedLayer());
    }

    @Override
    public void layerOrderChanged(LayerManager.LayerOrderChangeEvent e) {
    }

    @FunctionalInterface
    public static interface MapModeChangeListener {
        public void mapModeChange(MapMode var1, MapMode var2);
    }

    class ListAllButtonsAction
    extends AbstractAction {
        private JButton button;
        private final transient Collection<? extends HideableButton> buttons;

        ListAllButtonsAction(Collection<? extends HideableButton> buttons) {
            this.buttons = buttons;
        }

        JButton createButton() {
            this.button = new BasicArrowButton(3, null, null, Color.BLACK, null){

                @Override
                public Dimension getMaximumSize() {
                    Dimension dimension = ImageProvider.ImageSizes.TOOLBAR.getImageDimension();
                    dimension.width = Integer.MAX_VALUE;
                    return dimension;
                }
            };
            this.button.setAction(this);
            this.button.setAlignmentX(0.5f);
            this.button.setInheritsPopupMenu(true);
            return this.button;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JPopupMenu menu = new JPopupMenu();
            for (HideableButton hideableButton : this.buttons) {
                if (hideableButton.isExpert() && !ExpertToggleAction.isExpert()) continue;
                final HideableButton t = hideableButton;
                menu.add(new JCheckBoxMenuItem(new AbstractAction(){
                    {
                        this.putValue("Name", t.getActionName());
                        this.putValue("SmallIcon", t.getIcon());
                        this.putValue("SwingSelectedKey", t.isButtonVisible());
                        this.putValue("ShortDescription", I18n.tr("Hide or show this toggle button", new Object[0]));
                    }

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (Boolean.TRUE.equals(this.getValue("SwingSelectedKey"))) {
                            t.showButton();
                        } else {
                            t.hideButton();
                        }
                        MapFrame.this.validateToolBarsVisibility();
                    }
                }));
            }
            if (this.button != null && this.button.isShowing()) {
                Rectangle bounds = this.button.getBounds();
                menu.show(this.button, bounds.x + bounds.width, 0);
            }
        }
    }

    private final class SideToolbarPopupMenu
    extends JPopupMenu {
        private static final int staticMenuEntryCount = 2;
        private final JCheckBoxMenuItem doNotHide = new JCheckBoxMenuItem(new AbstractAction(I18n.tr("Do not hide toolbar", new Object[0])){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean sel = ((JCheckBoxMenuItem)e.getSource()).getState();
                Config.getPref().putBoolean("sidetoolbar.always-visible", sel);
            }
        });

        private SideToolbarPopupMenu() {
            this.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                    final Component src = ((JPopupMenu)e.getSource()).getInvoker();
                    if (src instanceof IconToggleButton) {
                        SideToolbarPopupMenu.this.insert(new JPopupMenu.Separator(), 0);
                        SideToolbarPopupMenu.this.insert(new AbstractAction(){
                            {
                                this.putValue("Name", I18n.tr("Hide this button", new Object[0]));
                                this.putValue("ShortDescription", I18n.tr("Click the arrow at the bottom to show it again.", new Object[0]));
                            }

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                ((IconToggleButton)src).setButtonHidden(true);
                                MapFrame.this.validateToolBarsVisibility();
                            }
                        }, 0);
                    }
                    SideToolbarPopupMenu.this.doNotHide.setSelected(Config.getPref().getBoolean("sidetoolbar.always-visible", true));
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                    while (SideToolbarPopupMenu.this.getComponentCount() > 2) {
                        SideToolbarPopupMenu.this.remove(0);
                    }
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent e) {
                }
            });
            this.add(new AbstractAction(I18n.tr("Hide edit toolbar", new Object[0])){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SIDE_TOOLBAR_VISIBLE.put(false);
                }
            });
            this.add(this.doNotHide);
        }
    }
}

