/*
 * Decompiled with CFR 0.152.
 */
package jrm.io.torrent.bencoding.types;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jrm.io.torrent.bencoding.types.IBencodable;

public class BList
implements IBencodable {
    public byte[] blob;
    private final List<IBencodable> list = new LinkedList<IBencodable>();

    public Iterator<IBencodable> getIterator() {
        return this.list.iterator();
    }

    public void add(IBencodable o) {
        this.list.add(o);
    }

    @Override
    public String bencodedString() {
        StringBuilder sb = new StringBuilder();
        sb.append("l");
        for (IBencodable entry : this.list) {
            sb.append(entry.bencodedString());
        }
        sb.append("e");
        return sb.toString();
    }

    @Override
    public byte[] bencode() {
        ArrayList<Byte> bytes = new ArrayList<Byte>();
        bytes.add((byte)108);
        for (IBencodable entry : this.list) {
            for (byte b : entry.bencode()) {
                bytes.add(b);
            }
        }
        bytes.add((byte)101);
        byte[] bencoded = new byte[bytes.size()];
        for (int i = 0; i < bytes.size(); ++i) {
            bencoded[i] = (Byte)bytes.get(i);
        }
        return bencoded;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (IBencodable entry : this.list) {
            sb.append(entry.toString());
        }
        sb.append(") ");
        return sb.toString();
    }
}

