/*
 * Decompiled with CFR 0.152.
 */
package jrm.misc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public final class Ideone {
    private final ArrayList<Interval> list = new ArrayList();

    public void add(int start, int end) {
        this.list.add(new Interval(start, end));
    }

    public ArrayList<Interval> merge() {
        return Ideone.merge(this.list);
    }

    public static ArrayList<Interval> merge(ArrayList<Interval> intervals) {
        if (intervals.size() <= 1) {
            return intervals;
        }
        Collections.sort(intervals, new Comparator<Interval>(){

            @Override
            public int compare(Interval i1, Interval i2) {
                return i1.getStart() - i2.getStart();
            }
        });
        Interval first = intervals.get(0);
        int start = first.getStart();
        int end = first.getEnd();
        ArrayList<Interval> result = new ArrayList<Interval>();
        for (int i = 1; i < intervals.size(); ++i) {
            Interval current = intervals.get(i);
            if (current.getStart() <= end) {
                end = Math.max(current.getEnd(), end);
                continue;
            }
            result.add(new Interval(start, end));
            start = current.getStart();
            end = current.getEnd();
        }
        result.add(new Interval(start, end));
        return result;
    }

    public static final class Interval {
        private final int start;
        private final int end;

        Interval() {
            this.start = 0;
            this.end = 0;
        }

        Interval(int s, int e) {
            this.start = s;
            this.end = e;
        }

        public int getStart() {
            return this.start;
        }

        public int getEnd() {
            return this.end;
        }
    }
}

