/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.app.gui.resources;

import com.jgoodies.app.gui.basics.WindowsAccentColors;
import com.jgoodies.app.gui.basics.icon.windows.WindowsIcon;
import com.jgoodies.common.jsdl.internal.ActionResource;
import com.jgoodies.common.jsdl.util.IconUtils;
import com.jgoodies.common.swing.ScreenScaling;
import com.jgoodies.fluent.Theme;
import com.jgoodies.fluent.internal.FluentResources;
import com.jgoodies.fluent.internal.IFluentResources;
import com.jgoodies.fluent.resources.Fluent;
import com.jgoodies.fluent.resources.WindowsThemes;
import com.jgoodies.fluent.tiles.AbstractTile;
import java.awt.Color;
import java.awt.Font;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.UIManager;

public class WindowsFluentResources
implements IFluentResources {
    private final Font titleLargeFont = UIManager.getFont("jgoodies-fluent.titleLarge.font");
    private final Font titleFont = UIManager.getFont("jgoodies-fluent.title.font");
    private final Font subtitleFont = UIManager.getFont("jgoodies-fluent.subtitle.font");
    private final Font bodyLargeFont = UIManager.getFont("jgoodies-fluent.bodyLarge.font");
    private final Font bodyStrongFont = UIManager.getFont("jgoodies-fluent.bodyStrong.font");
    private final Font bodyFont = UIManager.getFont("jgoodies-fluent.body.font");
    private final Font captionFont = UIManager.getFont("jgoodies-fluent.caption.font");
    private final Font tabBarFont;
    private final Font appBarTitleFont = UIManager.getFont("jgoodies-fluent.AppBar.title.font");
    private final Font appBarButtonFont = UIManager.getFont("jgoodies-fluent.AppBar.button.font");
    private final Font appBarButtonSelectedFont = UIManager.getFont("jgoodies-fluent.AppBar.button.selected.font");
    private final Font hubFont = UIManager.getFont("jgoodies-fluent.Hub.font");
    private final Font hubSectionFont = UIManager.getFont("jgoodies-fluent.HubSection.font");
    private final Font tileBaseFont;
    private final Font tileTitleFont;
    private Icon moreIcon;
    private Locale cachedLocale;
    private ResourceBundle cachedBundle;

    public static void install() {
        FluentResources.setInstance(new WindowsFluentResources());
    }

    protected WindowsFluentResources() {
        this.tabBarFont = UIManager.getFont("jgoodies-fluent.TabBar.font");
        this.tileTitleFont = UIManager.getFont("jgoodies-fluent.Tile.title.font");
        this.tileBaseFont = UIManager.getFont("jgoodies-fluent.Tile.base.font");
    }

    @Override
    public Theme getTheme() {
        return WindowsThemes.light();
    }

    @Override
    public Font getTitleLargeFont() {
        return this.titleLargeFont;
    }

    @Override
    public Font getTitleFont() {
        return this.titleFont;
    }

    @Override
    public Font getSubtitleFont() {
        return this.subtitleFont;
    }

    @Override
    public Font getBodyLargeFont() {
        return this.bodyLargeFont;
    }

    @Override
    public Font getBodyStrongFont() {
        return this.bodyStrongFont;
    }

    @Override
    public Font getBodyFont() {
        return this.bodyFont;
    }

    @Override
    public Font getCaptionFont() {
        return this.captionFont;
    }

    @Override
    public Font getAppBarTitleFont() {
        return this.appBarTitleFont != null ? this.appBarTitleFont : this.bodyStrongFont;
    }

    @Override
    public Font getAppBarButtonFont() {
        return this.appBarButtonFont != null ? this.appBarButtonFont : this.bodyFont;
    }

    @Override
    public Font getAppBarButtonSelectedFont() {
        return this.appBarButtonSelectedFont != null ? this.appBarButtonSelectedFont : this.bodyStrongFont;
    }

    @Override
    public Icon getAppBarMenuIcon() {
        return WindowsIcon.CHEVRON_DOWN_MED.toIcon(14);
    }

    @Override
    public Icon getAppBarMenuIconDisabled() {
        return WindowsIcon.CHEVRON_DOWN_MED.toIcon(14, Color.GRAY);
    }

    @Override
    public Icon getAppBarMoreIcon() {
        if (this.moreIcon == null) {
            this.moreIcon = IconUtils.pad(WindowsIcon.MORE, ScreenScaling.physicalInsets(2, 0, 0, 0));
        }
        return this.moreIcon;
    }

    @Override
    public Icon getBackIcon() {
        return IconUtils.pad(WindowsIcon.BACK.toIcon(14), ScreenScaling.physicalInsets(2, 0, 0, 0));
    }

    @Override
    public Icon getBackIconDisabled() {
        return IconUtils.pad(WindowsIcon.BACK.toIcon(14, Color.GRAY), ScreenScaling.physicalInsets(2, 0, 0, 0));
    }

    @Override
    public Icon getNavigationViewMenuIcon() {
        return WindowsIcon.GLOBAL_NAV_BUTTON.toIcon(14);
    }

    @Override
    public Icon getNavigationViewSearchIcon() {
        return WindowsIcon.SEARCH.toIcon(14);
    }

    @Override
    public Icon getNavigationViewSearchFieldIcon() {
        return WindowsIcon.SEARCH_MEDIUM.toIcon(14);
    }

    @Override
    public Icon getNavigationViewSettingsIcon() {
        return IconUtils.pad(WindowsIcon.SETTINGS.toIcon(14), ScreenScaling.physicalInsets(0, 0, 0, 0));
    }

    @Override
    public String getNavigationViewSearchText(Locale locale) {
        return this.getBundle(locale).getString("NavigationView.Search");
    }

    @Override
    public Font getTabBarFont() {
        return this.tabBarFont != null ? this.tabBarFont : this.captionFont;
    }

    @Override
    public ActionResource getTabBarNewTabResource(Locale locale) {
        return new ActionResource.Builder().text(this.getBundle(locale).getString("TabBar.NewTab.Action.text"), new Object[0]).icon(WindowsIcon.ADD.toIcon(14, Color.BLACK)).accelerator(this.getBundle(locale).getString("TabBar.NewTab.Action.accelerator")).build();
    }

    @Override
    public ActionResource getTabBarNewTabToTheRightResource(Locale locale) {
        return new ActionResource.Builder().text(this.getBundle(locale).getString("TabBar.NewTabToTheRight.Action.text"), new Object[0]).build();
    }

    @Override
    public ActionResource getTabBarSearchTabsResource(Locale locale) {
        return new ActionResource.Builder().text(this.getBundle(locale).getString("TabBar.SearchTabs.Action.text"), new Object[0]).icon(WindowsIcon.CHEVRON_DOWN.toIcon(14, Color.BLACK)).build();
    }

    @Override
    public ActionResource getTabBarMoveTabToNewWindowResource(Locale locale) {
        return new ActionResource.Builder().text(this.getBundle(locale).getString("TabBar.MoveTabToNewWindow.Action.text"), new Object[0]).build();
    }

    @Override
    public ActionResource getTabBarRefreshTabResource(Locale locale) {
        return new ActionResource.Builder().text(this.getBundle(locale).getString("TabBar.RefreshTab.Action.text"), new Object[0]).icon(IconUtils.pad(WindowsIcon.REFRESH.toIcon(14), ScreenScaling.physicalInsets(0, 0, 0, 0))).accelerator(this.getBundle(locale).getString("TabBar.RefreshTab.Action.accelerator")).build();
    }

    @Override
    public ActionResource getTabBarPinTabResource(Locale locale) {
        return new ActionResource.Builder().text(this.getBundle(locale).getString("TabBar.PinTab.Action.text"), new Object[0]).icon(IconUtils.pad(WindowsIcon.PIN.toIcon(14), ScreenScaling.physicalInsets(0, 0, 0, 0))).build();
    }

    @Override
    public ActionResource getTabBarUnpinTabResource(Locale locale) {
        return new ActionResource.Builder().text(this.getBundle(locale).getString("TabBar.UnpinTab.Action.text"), new Object[0]).icon(IconUtils.pad(WindowsIcon.PIN.toIcon(14), ScreenScaling.physicalInsets(0, 0, 0, 0))).build();
    }

    @Override
    public ActionResource getTabBarCloseTabResource(Locale locale) {
        return new ActionResource.Builder().text(this.getBundle(locale).getString("TabBar.CloseTab.Action.text"), new Object[0]).icon(WindowsIcon.CANCEL.toIcon(14, new Color(72, 72, 72))).rolloverIcon(WindowsIcon.CANCEL.toIcon(14, Color.BLACK)).accelerator(this.getBundle(locale).getString("TabBar.CloseTab.Action.accelerator")).build();
    }

    @Override
    public ActionResource getTabBarCloseOtherTabsResource(Locale locale) {
        return new ActionResource.Builder().text(this.getBundle(locale).getString("TabBar.CloseOtherTabs.Action.text"), new Object[0]).build();
    }

    @Override
    public ActionResource getTabBarCloseTabsToTheRightResource(Locale locale) {
        return new ActionResource.Builder().text(this.getBundle(locale).getString("TabBar.CloseTabsToTheRight.Action.text"), new Object[0]).build();
    }

    @Override
    public Color toBackground(AbstractTile.TileState state) {
        switch (state) {
            case ERROR: {
                return WindowsAccentColors.RED1;
            }
            case WARNING: {
                return WindowsAccentColors.ORANGE1;
            }
            case SUCCESS: {
                return WindowsAccentColors.GREEN1;
            }
            case NEUTRAL: {
                return Color.WHITE;
            }
            case INFO: {
                return WindowsAccentColors.GRAY1;
            }
            case DEFAULT: {
                return WindowsAccentColors.BLUE1;
            }
        }
        throw new IllegalStateException("Unknown tile state " + (Object)((Object)state));
    }

    @Override
    public Color toForeground(AbstractTile.TileState state) {
        switch (state) {
            case ERROR: 
            case WARNING: 
            case SUCCESS: 
            case INFO: 
            case DEFAULT: {
                return Color.WHITE;
            }
            case NEUTRAL: {
                return Color.BLACK;
            }
        }
        throw new IllegalStateException("Unknown tile state " + (Object)((Object)state));
    }

    @Override
    public Font getHubFont() {
        return this.hubFont != null ? this.hubFont : this.titleFont;
    }

    @Override
    public Font getHubSectionFont() {
        return this.hubSectionFont != null ? this.hubSectionFont : this.bodyLargeFont;
    }

    @Override
    public Font getTileBaseFont() {
        return this.tileBaseFont != null ? this.tileBaseFont : this.captionFont;
    }

    @Override
    public Font getTileTitleFont() {
        return this.tileTitleFont != null ? this.tileTitleFont : this.bodyFont;
    }

    private ResourceBundle getBundle(Locale locale) {
        if (this.cachedLocale == locale) {
            return this.cachedBundle;
        }
        this.cachedBundle = new Fluent().getBundle(locale);
        this.cachedLocale = locale;
        return this.cachedBundle;
    }
}

