/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.value;

import com.jgoodies.binding.value.AbstractWrappedValueModel;
import com.jgoodies.binding.value.BindingConverter;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.function.Function;

public final class ConverterValueModel<S, T>
extends AbstractWrappedValueModel {
    private final ValueModel source;
    private final Function<S, T> sourceToTarget;
    private final Function<T, S> targetToSource;

    public ConverterValueModel(ValueModel source, BindingConverter<S, T> converter) {
        this(source, src -> converter.targetValue(src), trgt -> converter.sourceValue(trgt));
    }

    public ConverterValueModel(ValueModel source, Function<S, T> sourceToTarget, Function<T, S> targetToSource) {
        super(source);
        this.source = source;
        this.sourceToTarget = sourceToTarget;
        this.targetToSource = targetToSource;
    }

    public Object convertFromSubject(Object sourceValue) {
        return this.sourceToTarget.apply(sourceValue);
    }

    @Override
    public void setValue(Object targetValue) {
        this.source.setValue(this.targetToSource.apply(targetValue));
    }

    @Override
    public Object getValue() {
        return this.convertFromSubject(this.source.getValue());
    }

    @Override
    protected PropertyChangeListener createValueChangeHandler() {
        return this::onValueChanged;
    }

    private void onValueChanged(PropertyChangeEvent evt) {
        Object convertedOldValue = evt.getOldValue() == null ? null : this.convertFromSubject(evt.getOldValue());
        Object convertedNewValue = evt.getNewValue() == null ? null : this.convertFromSubject(evt.getNewValue());
        this.fireValueChange(convertedOldValue, convertedNewValue);
    }
}

