/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.common.jsdl.check;

import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.jsdl.check.DefaultStyleViolationReporter;
import com.jgoodies.common.jsdl.check.SeverityLevel;
import com.jgoodies.common.jsdl.check.StyleCheck;
import com.jgoodies.common.jsdl.check.StyleCheckConfiguration;
import com.jgoodies.common.jsdl.check.StyleChecks;
import com.jgoodies.common.jsdl.check.StyleViolationReporter;
import java.util.List;
import java.util.function.BooleanSupplier;

public class StyleChecker {
    private static StyleChecker current;
    private StyleCheckConfiguration defaultConfiguration;
    private StyleViolationReporter reporter;
    private StyleCheckConfiguration configuration;

    protected StyleChecker() {
        this(null);
    }

    protected StyleChecker(StyleCheckConfiguration configuration) {
        this.configuration = configuration;
    }

    public static void setupStrictDevelopmentMode() {
        StyleChecker.getCurrent().setReporter(new DefaultStyleViolationReporter(SeverityLevel.IGNORE));
    }

    public static void setupDevelopmentMode() {
        StyleChecker.getCurrent().setReporter(new DefaultStyleViolationReporter(SeverityLevel.INFO));
    }

    public static void setupDefaultRuntimeMode() {
        StyleChecker.getCurrent().setReporter(new DefaultStyleViolationReporter(SeverityLevel.ERROR));
    }

    public static StyleCheckConfiguration ignore(StyleCheck ... checks) {
        Preconditions.checkNotNull(checks, "The %s must not be null.", "checks");
        StyleCheckConfiguration original = StyleChecker.getCurrent().getConfiguration();
        StyleCheckConfiguration child = new StyleCheckConfiguration(original);
        StyleChecker.getCurrent().setConfiguration(child);
        for (StyleCheck check : checks) {
            child.put(check, SeverityLevel.IGNORE);
        }
        return original;
    }

    public static StyleCheckConfiguration ignoreAll() {
        List<StyleCheck> checks = StyleChecks.getCurrent().allChecks();
        return StyleChecker.ignore(checks.toArray(new StyleCheck[checks.size()]));
    }

    public static boolean isIgnored(StyleCheck check) {
        return StyleChecker.getCurrent().getConfiguration().get(check).equals((Object)SeverityLevel.IGNORE);
    }

    public static void restore(StyleCheckConfiguration configuration) {
        StyleChecker.getCurrent().setConfiguration(configuration);
    }

    public static void restoreDefault() {
        StyleChecker.getCurrent().setConfiguration(null);
    }

    public static StyleChecker getCurrent() {
        if (current == null) {
            current = new StyleChecker();
        }
        return current;
    }

    public static void setCurrent(StyleChecker newInstance) {
        current = newInstance;
    }

    public static void check(StyleCheck check, boolean expression) {
        StyleChecker.check(check, () -> expression);
    }

    public static void check(StyleCheck check, BooleanSupplier deferredExpression) {
        if (StyleChecker.isIgnored(check) || deferredExpression.getAsBoolean()) {
            return;
        }
        StyleChecker.getCurrent();
        StyleChecker.report(check, check.getDescription(), new Object[0]);
    }

    public static void check(StyleCheck check, boolean expression, String messageFormat, Object ... messageArgs) {
        StyleChecker.check(check, () -> expression, messageFormat, messageArgs);
    }

    public static void check(StyleCheck check, BooleanSupplier deferredExpression, String messageFormat, Object ... messageArgs) {
        if (StyleChecker.isIgnored(check) || deferredExpression.getAsBoolean()) {
            return;
        }
        StyleChecker.getCurrent();
        StyleChecker.report(check, check.getDescription() + '\n' + messageFormat, messageArgs);
    }

    public static void report(StyleCheck check, String message, Object ... args) {
        SeverityLevel level = StyleChecker.getCurrent().getConfiguration().get(check);
        if (!level.equals((Object)SeverityLevel.IGNORE)) {
            StyleChecker.getCurrent().getReporter().report(level, check, Strings.get(message, args));
        }
    }

    public final StyleCheckConfiguration getConfiguration() {
        if (this.configuration == null) {
            this.configuration = this.getDefaultConfiguration();
        }
        return this.configuration;
    }

    public final void setConfiguration(StyleCheckConfiguration configuration) {
        this.configuration = configuration;
    }

    public final StyleCheckConfiguration getDefaultConfiguration() {
        if (this.defaultConfiguration == null) {
            this.defaultConfiguration = this.createDefaultConfiguration();
        }
        return this.defaultConfiguration;
    }

    protected StyleCheckConfiguration createDefaultConfiguration() {
        StyleCheckConfiguration root = new StyleCheckConfiguration(null);
        for (StyleCheck check : StyleChecks.getCurrent().allChecks()) {
            root.put(check, check.getDefaultSeverityLevel());
        }
        return root;
    }

    public final StyleViolationReporter getReporter() {
        if (this.reporter == null) {
            this.reporter = new DefaultStyleViolationReporter();
        }
        return this.reporter;
    }

    public final void setReporter(StyleViolationReporter reporter) {
        this.reporter = reporter;
    }
}

