/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.common.jsdl.i18n;

import com.jgoodies.application.Application;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.common.base.Strings;
import com.jgoodies.common.jsdl.i18n.Key;
import com.jgoodies.common.jsdl.i18n.ResourceProvider;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.MissingResourceException;
import java.util.logging.Logger;

public final class Resources {
    private static InjectionHandler defaultHandler = new DefaultInjectionHandler();

    private Resources() {
    }

    public static void setDefaultHandler(InjectionHandler newDefaultHandler) {
        defaultHandler = Preconditions.checkNotNull(newDefaultHandler, "The %s must not be null.", "new default handler");
    }

    public static <T> T get(Class<T> injectionClass) {
        return Resources.get(injectionClass, defaultHandler);
    }

    private static <T> T get(Class<T> injectionClass, InjectionHandler handler) {
        Injector<T> injector = new Injector<T>(injectionClass, handler);
        T instance = injector.createInstance();
        injector.injectResources(instance);
        return instance;
    }

    public static void injectInto(Object instance) {
        Injector injector = new Injector(instance.getClass(), defaultHandler);
        injector.injectResources(instance);
    }

    public static void injectInto(Class<?> injectionClass) {
        Resources.injectInto(injectionClass, defaultHandler);
    }

    private static <T> void injectInto(Class<T> injectionClass, InjectionHandler handler) {
        Injector<T> injector = new Injector<T>(injectionClass, handler);
        injector.injectResources(null);
    }

    public static class DefaultInjectionHandler
    implements InjectionHandler {
        private final String keyFormat;

        public DefaultInjectionHandler() {
            this("{%s}");
        }

        public DefaultInjectionHandler(String keyFormat) {
            this.keyFormat = keyFormat;
        }

        @Override
        public void handleFieldSetFailed(Field field, String resourceKey, Exception ex) {
            ex.printStackTrace();
        }

        @Override
        public String handleMissingResource(Field field, ResourceMap map, String key, MissingResourceException ex) {
            String message = String.format("Missing resource for key \"%1$s\"\nbundle base name=%2$s\ndeclaring class =%3$s\nkey       =\"%1$s\"\nfield name=\"%4$s\"\nfield modifiers=%5$s", key, map.getBaseName(), field.getDeclaringClass().getName(), field.getName(), Modifier.toString(field.getModifiers()));
            Logger.getLogger(DefaultInjectionHandler.class.getName()).info(message);
            return String.format(this.keyFormat, key);
        }
    }

    public static interface InjectionHandler {
        public void handleFieldSetFailed(Field var1, String var2, Exception var3);

        public String handleMissingResource(Field var1, ResourceMap var2, String var3, MissingResourceException var4);
    }

    private static final class Injector<R> {
        private final Class<R> injectionClass;
        private final InjectionHandler handler;
        private final ResourceMap resourceMap;
        private final String prefix;

        Injector(Class<R> injectionClass, InjectionHandler handler) {
            Preconditions.checkNotNull(injectionClass, "The %s must not be null.", "the class to inject resources into");
            Preconditions.checkNotNull(handler, "The %s must not be null.", "the injection handler");
            this.injectionClass = injectionClass;
            this.handler = handler;
            ResourceProvider annotation = injectionClass.getAnnotation(ResourceProvider.class);
            Class<R> resourceClass = annotation == null || annotation.resourceClass() == Object.class ? injectionClass : annotation.resourceClass();
            this.resourceMap = Application.getResourceMap(resourceClass);
            this.prefix = annotation == null || Strings.isBlank(annotation.keyPrefix()) ? "" : annotation.keyPrefix() + '.';
        }

        R createInstance() {
            try {
                Constructor<R> constructor = this.injectionClass.getDeclaredConstructor(new Class[0]);
                constructor.setAccessible(true);
                return constructor.newInstance(null);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                ex.printStackTrace();
                return null;
            }
        }

        void injectResources(Object instance) {
            for (Field field : this.injectionClass.getDeclaredFields()) {
                Object value;
                boolean isStatic;
                boolean bl = isStatic = (field.getModifiers() & 8) != 0;
                if (isStatic && instance != null) continue;
                Class<?> fieldType = field.getType();
                String key = this.mapToKey(field);
                try {
                    value = this.resourceMap.getObject(key, fieldType);
                }
                catch (MissingResourceException ex) {
                    value = this.handler.handleMissingResource(field, this.resourceMap, key, ex);
                }
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                try {
                    field.set(instance, value);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    this.handler.handleFieldSetFailed(field, key, ex);
                }
            }
        }

        private String mapToKey(Field field) {
            Key keyAnnotation = field.getAnnotation(Key.class);
            if (keyAnnotation != null) {
                String key = keyAnnotation.value();
                Preconditions.checkNotBlank(key, "The %s must not be null, empty, or whitespace.", "the @Key's text");
                return keyAnnotation.prefix() ? this.prefix + key : key;
            }
            String fieldName = field.getName();
            String fieldKey = fieldName.replace('_', '.');
            return this.prefix + fieldKey;
        }
    }
}

